/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.callerid;

import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.simplermi.SimpleRMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Device;
import ordermate.database.hardware.physical.callerid.Call;
import ordermate.database.hardware.physical.callerid.CallerIDNetwork;
import ordermate.database.hardware.physical.callerid.CallerIDNetworkImpl;
import ordermate.database.hardware.physical.callerid.CallerIDUnitCheckThread;
import ordermate.database.hardware.physical.callerid.CallerUdpListener;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_calleridunit")
@AccessType(value="property")
public class CallerIDUnit
extends Device {
    public static final Props Properties = new Props();
    public transient Signal<Call, ?, ?, ?, ?> callDetected = Signals.createSignal(Call.class, "theCall");
    public transient Signal<Integer, ?, ?, ?, ?> callPickedUp = Signals.createSignal(Integer.class, "lineNumber");
    private static CallerIDUnit unit;
    static Call lastCall;
    private int numberOfLines;
    private int lineNumbersStartAt;
    private transient OutputPort outputPort;
    static final StringBuilder dataBuffer;
    static Log portLog;

    public CallerIDUnit() {
        this.terminals = (PersistentWriteableList)this.createList(CallerIDUnit.Properties.TERMINALS);
    }

    @Column(name="number_of_lines")
    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    @Transient
    public int getFirstLineNumber() {
        return this.lineNumbersStartAt;
    }

    @Override
    public void startup(Terminal localhost) throws Exception {
        if (this.getHost().equals(localhost)) {
            this.setupLog();
            portLog = LogFactory.getLog((String)this.getPort());
            if ("IP".equals(this.getPortType())) {
                CallerUdpListener.setUp();
            } else {
                if (this.outputPort == null) {
                    this.setOutputPort(this.createPort(true));
                }
                this.outputPort.openConnection();
                Thread checkThread = new Thread((Runnable)new CallerIDUnitCheckThread(this.outputPort), "CallerID Checking Thread " + this.getLabel());
                checkThread.start();
            }
        }
        if (localhost.getAvailableCallerIDUnit() != null) {
            SimpleRMI.shareObject(new CallerIDNetworkImpl(this), "Caller ID Control");
        }
    }

    protected void setOutputPort(OutputPort newPort) {
        if (newPort != null) {
            this.outputPort = newPort;
        }
    }

    public void notifyCallPickedUp(final int lineNumber) {
        List<Terminal> terms = Terminal.getAllWaiterMateTerminals();
        for (final Terminal terminal : terms) {
            if (terminal.getAvailableCallerIDUnit() == null) continue;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        CallerIDNetwork control = (CallerIDNetwork)SimpleRMI.getObject(terminal.getAddress(), "Caller ID Control", terminal.getRmiPort());
                        control.callPickedUp(lineNumber);
                    }
                    catch (Exception e) {
                        OrderMate.LOG.warn("Error notifying terminal " + terminal + " of call picked up on line " + lineNumber, (Throwable)e);
                    }
                }
            }, "Notify " + terminal.getName() + " call picked up");
            thread.start();
        }
    }

    public static CallerIDUnit getUnit() {
        if (unit == null) {
            String sql = Query.select(CallerIDUnit.class).toString();
            unit = PersistenceManager.getObject(CallerIDUnit.class, sql, new Object[0]);
        }
        return unit;
    }

    static Call getLastCall() {
        return lastCall;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.callDetected = Signals.createSignal(Call.class, "theCall");
        this.callPickedUp = Signals.createSignal(Integer.class, "lineNumber");
    }

    @Column(name="line_numbers_start_at")
    public int getLineNumbersStartAt() {
        return this.lineNumbersStartAt;
    }

    public void setLineNumbersStartAt(int numbersStartAt) {
        this.lineNumbersStartAt = numbersStartAt;
    }

    public void setNumberOfLines(int numLines) {
        this.numberOfLines = numLines;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getHost() {
        return super.getHost();
    }

    @Override
    @Column(name="port")
    public String getPort() {
        return super.getPort();
    }

    @Override
    @Column(name="port_speed")
    public int getPortSpeed() {
        return super.getPortSpeed();
    }

    @Override
    @Column(name="port_type")
    public String getPortType() {
        return super.getPortType();
    }

    @Override
    @Column(name="flow_control")
    public void setFlowControl(String control) {
        super.setFlowControl(control);
    }

    @Override
    public void setHost(Terminal newHost) {
        super.setHost(newHost);
    }

    @Override
    public void setPort(String newPort) {
        super.setPort(newPort);
    }

    @Override
    public void setPortSpeed(int newSpeed) {
        super.setPortSpeed(newSpeed);
    }

    @Override
    public void setPortType(String newPortType) {
        super.setPortType(newPortType);
    }

    static {
        lastCall = null;
        dataBuffer = new StringBuilder();
    }

    public static class Props
    extends Device.Props {
        public PropertiedObject.Property NUMBER_OF_LINES;
        public PropertiedObject.Property LINE_NUMBERS_START_AT;
    }
}

