/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.callerid;

import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.util.StringUtils;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.hardware.physical.callerid.Call;
import ordermate.database.hardware.physical.callerid.CallerIDUnit;

class CallerIDUnitCheckThread
implements Runnable {
    private static final long RECONNECT_PERIOD = 30000L;
    private static final long THREAD_SLEEP_TIME = 500L;
    private OutputPort thePort;
    private long lastCallTime = System.currentTimeMillis();

    public CallerIDUnitCheckThread(OutputPort port) {
        this.thePort = port;
    }

    @Override
    public void run() {
        while (System.currentTimeMillis() - this.lastCallTime < 30000L) {
            try {
                if (this.thePort.hasData()) {
                    int length;
                    int dif;
                    CallerIDUnit.dataBuffer.append(new String(this.thePort.receiveBytes()));
                    CallerIDUnit.portLog.info((Object)("Received data from Caller ID: '" + CallerIDUnit.dataBuffer + "'" + CallerIDUnit.dataBuffer.length()));
                    String callData = CallerIDUnit.dataBuffer.toString();
                    ExperimentalFeature feature = ExperimentalFeature.find("Pad Caller");
                    if (feature != null && feature.getIntValue(-1) > 0 && (dif = (length = feature.getIntValue(65).intValue()) - callData.length()) > 0) {
                        callData = StringUtils.rightPad(callData.substring(0, callData.length() - 2), length - 2, '~') + "\r\n";
                        CallerIDUnit.portLog.info((Object)("Padding out with " + dif + " now:" + callData));
                    }
                    if (Call.isValid(callData)) {
                        Call aCall;
                        CallerIDUnit.lastCall = aCall = new Call(callData);
                        CallerIDUnit.dataBuffer.delete(0, callData.length());
                        Call.handleCall(CallerIDUnit.lastCall);
                    } else {
                        CallerIDUnit.portLog.warn((Object)"Incoming call detected, but was not of correct format. Continuing to buffer.");
                    }
                    this.lastCallTime = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                CallerIDUnit.portLog.error((Object)"Cannot detect incoming call.", (Throwable)e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                CallerIDUnit.portLog.error((Object)"Caller ID check thread sleep interrupted", (Throwable)e);
            }
        }
        this.reconnect();
    }

    private void reconnect() {
        try {
            CallerIDUnit.portLog.info((Object)"Re-connecting to the Caller ID unit");
            this.thePort.closeConnection();
            this.thePort.openConnection();
            Thread checkThread = new Thread((Runnable)new CallerIDUnitCheckThread(this.thePort), "CallerID Checking Thread " + this.thePort.getName());
            checkThread.start();
        }
        catch (Exception e) {
            CallerIDUnit.portLog.error((Object)"Caller ID could not be restarted", (Throwable)e);
        }
    }
}

