/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.callerid;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.callerid.Call;
import ordermate.database.hardware.physical.callerid.CallerIDUnit;

public class CallerUdpListener {
    private static CallerUdpListener instance;
    private static final int PORT = 3520;
    private static final int TIMEOUT = 60000;
    private static final int START = 21;
    private static final int LENGTH = 83;
    private boolean running = false;

    public static CallerUdpListener getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("Cannot ask for Caller UDP Listener before it has been set up");
    }

    public static void setUp() {
        if (instance == null) {
            instance = new CallerUdpListener();
        }
    }

    private CallerUdpListener() {
        OrderMate.LOG.info("Starting up Caller UDP Listener on port:3520");
        this.startListening();
    }

    public void startListening() {
        if (this.running) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                CallerUdpListener.this.running = true;
                while (CallerUdpListener.this.running) {
                    DatagramSocket socket = null;
                    try {
                        socket = new DatagramSocket(3520);
                        socket.setSoTimeout(60000);
                        DatagramPacket packet = new DatagramPacket(new byte[83], 83);
                        socket.receive(packet);
                        CallerUdpListener.this.processData(new String(packet.getData()));
                        continue;
                    }
                    catch (SocketTimeoutException packet) {
                        continue;
                    }
                    catch (SocketException ex) {
                        CallerIDUnit.portLog.error((Object)"Cannot start datagram socket.", (Throwable)ex);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e1) {
                            CallerIDUnit.portLog.error((Object)"Interrupted while sleeping");
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        CallerIDUnit.portLog.error((Object)"Cannot read data from caller id socket.", (Throwable)ex);
                        continue;
                    }
                    catch (Exception ex) {
                        CallerIDUnit.portLog.error((Object)"Unexpected error when processing caller id data.", (Throwable)ex);
                        continue;
                    }
                    finally {
                        if (socket == null) continue;
                        socket.disconnect();
                        socket.close();
                        continue;
                    }
                    break;
                }
                return;
            }
        });
        thread.start();
    }

    protected void processData(String data) {
        OrderMate.LOG.info("Got potential caller ID:" + data);
        if (data.length() > 21) {
            String subData = data.substring(21) + " \r\n";
            if (Call.isValid(subData)) {
                Call.handleCall(new Call(subData));
            } else {
                CallerIDUnit.portLog.warn((Object)("Got garbage from caller id udp:" + subData));
            }
        }
    }

    public void stopListening() {
        this.running = false;
    }
}

