/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_kts_docket_data")
@AccessType(value="property")
public class KTSDocketData
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Date created;
    private Date modified;
    private int initialTime;
    private int ktsId;
    private int wentLive;
    private int wentHold;
    private int wentBump;
    private int timeLive;
    private int timeHold;
    private KTSDocketState state;
    private Reference<KTSDocketPrinter> printer;
    private Reference<SalesAccountDocket> salesAccountDocket;
    private Reference<Account> salesAccount;

    public KTSDocketData() {
        this.printer = this.createReference(KTSDocketData.Properties.PRINTER);
        this.salesAccountDocket = this.createReference(KTSDocketData.Properties.SALES_ACCOUNT_DOCKET);
        this.salesAccount = this.createReference(KTSDocketData.Properties.SALES_ACCOUNT);
    }

    public KTSDocketData(KTSDocketPrinter printer, SalesAccountDocket salesDocket) {
        this.printer = this.createReference(KTSDocketData.Properties.PRINTER);
        this.salesAccountDocket = this.createReference(KTSDocketData.Properties.SALES_ACCOUNT_DOCKET);
        this.salesAccount = this.createReference(KTSDocketData.Properties.SALES_ACCOUNT);
        this.setPrinter(printer);
        this.setSalesAccountDocket(salesDocket);
        if (salesDocket != null) {
            this.setSalesAccount(salesDocket.getSalesAccount());
        }
        this.created = new Date();
        this.modified = new Date();
    }

    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date newCreated) {
        this.created = newCreated;
    }

    @Column(name="modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getModified() {
        return this.modified;
    }

    protected void setModified(Date value) {
        this.modified = value;
    }

    @Column(name="kts_id")
    public int getKtsId() {
        return this.ktsId;
    }

    public void setKtsId(int newKtsId) {
        this.ktsId = newKtsId;
    }

    @Column(name="initial_time")
    public int getInitialTime() {
        return this.initialTime;
    }

    public void setInitialTime(int value) {
        this.initialTime = value;
    }

    @Column(name="went_live")
    public int getWentLive() {
        return this.wentLive;
    }

    public void setWentLive(int newWentLive) {
        this.wentLive = newWentLive;
    }

    @Column(name="went_hold")
    public int getWentHold() {
        return this.wentHold;
    }

    public void setWentHold(int newWentHold) {
        this.wentHold = newWentHold;
    }

    @Column(name="went_bump")
    public int getWentBump() {
        return this.wentBump;
    }

    public void setWentBump(int newWentBump) {
        this.wentBump = newWentBump;
    }

    @Column(name="time_live")
    public int getTimeLive() {
        return this.timeLive;
    }

    public void setTimeLive(int newTimeLive) {
        this.timeLive = newTimeLive;
    }

    @Column(name="time_hold")
    public int getTimeHold() {
        return this.timeHold;
    }

    public void setTimeHold(int newTimeHold) {
        this.timeHold = newTimeHold;
    }

    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    public KTSDocketState getState() {
        return this.state;
    }

    public void setState(KTSDocketState newState) {
        this.state = newState;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_config_physical_printer")
    public KTSDocketPrinter getPrinter() {
        return this.printer.get();
    }

    public void setPrinter(KTSDocketPrinter newPrinter) {
        this.printer.set(newPrinter);
    }

    @Transient
    public SalesAccountDocket getSalesAccountDocket() {
        return this.salesAccountDocket.get();
    }

    public void setSalesAccountDocket(SalesAccountDocket newDocket) {
        this.salesAccountDocket.set(newDocket);
    }

    @Transient
    public Account getSalesAccount() {
        return this.salesAccount.get();
    }

    public void setSalesAccount(Account newSalesAccount) {
        this.salesAccount.set(newSalesAccount);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (this.salesAccount == null) {
            throw new IllegalStateException("No Sales Account has been linked to the KTS Docket Data!");
        }
        this.modified = new Date();
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Date> CREATED;
        public PropertiedObject.Property<Date> MODIFIED;
        public PropertiedObject.Property KTS_ID;
        public PropertiedObject.Property INITIAL_TIME;
        public PropertiedObject.Property WENT_LIVE;
        public PropertiedObject.Property WENT_HOLD;
        public PropertiedObject.Property WENT_BUMP;
        public PropertiedObject.Property TIME_LIVE;
        public PropertiedObject.Property TIME_HOLD;
        public PropertiedObject.Property<KTSDocketState> STATE;
        public PropertiedObject.Property<KTSDocketPrinter> PRINTER;
        public PropertiedObject.Property<SalesAccountDocket> SALES_ACCOUNT_DOCKET;
        public PropertiedObject.Property<Account> SALES_ACCOUNT;
    }
}

