/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;

public class KTSDocketDataSummary
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Integer averageLiveTime;
    private Integer averageHoldTime;
    private Integer highestTime;
    private Integer lowestTime;
    private Integer size;

    public int getHighestTime() {
        return this.highestTime == null ? 0 : this.highestTime;
    }

    public int getLowestTime() {
        return this.lowestTime == null ? 0 : this.lowestTime;
    }

    public int getAverageLiveTime() {
        return this.averageLiveTime == null ? 0 : this.averageLiveTime;
    }

    public int getAverageHoldTime() {
        return this.averageHoldTime == null ? 0 : this.averageHoldTime;
    }

    public int getAverageTotalTime() {
        return this.getAverageHoldTime() + this.getAverageLiveTime();
    }

    public int getSize() {
        return this.size == null ? 0 : this.size;
    }

    public static ObjectQuery getSummaryQuery(Date from, Date to, KTSDocketPrinter printer) {
        Date fromDate = from == null ? new Date() : from;
        Date toDate = to == null ? new Date() : to;
        ObjectQuery query = Query.count(KTSDocketData.class, "size").avg(KTSDocketData.Properties.TIME_HOLD, "average_hold_time").avg(KTSDocketData.Properties.TIME_LIVE, "average_live_time").selectFunc("max(sales_kts_docket_data.time_live + sales_kts_docket_data.time_hold) as 'highest'").selectFunc("min(sales_kts_docket_data.time_live + sales_kts_docket_data.time_hold) as 'lowest'").equals(KTSDocketData.Properties.STATE, (Object)KTSDocketState.Bump).wherePropertyBetween(KTSDocketData.Properties.CREATED, fromDate, toDate, SQLDateType.TIMESTAMP).wherePropertyBetween(KTSDocketData.Properties.TIME_LIVE, 0, Integer.MAX_VALUE);
        if (printer != null) {
            query.equals(KTSDocketData.Properties.PRINTER, printer);
        }
        return query;
    }

    protected void setAverageLiveTime(Integer averageLiveTime) {
        this.averageLiveTime = averageLiveTime;
    }

    protected void setAverageHoldTime(Integer averageHoldTime) {
        this.averageHoldTime = averageHoldTime;
    }

    protected void setHighestTime(Integer highestTime) {
        this.highestTime = highestTime;
    }

    protected void setLowestTime(Integer lowestTime) {
        this.lowestTime = lowestTime;
    }

    protected void setSize(Integer size) {
        this.size = size;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property AVERAGE_LIVE_TIME;
        public PropertiedObject.Property AVERAGE_HOLD_TIME;
        public PropertiedObject.Property HIGHEST_TIME;
        public PropertiedObject.Property LOWEST_TIME;
        public PropertiedObject.Property SIZE;
        public PersistentObject.DerivedProperty AVERAGE_TOTAL_TIME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KTSDocketDataSummary.class), "averageTotalTime");
    }
}

