/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.simplermi.SimpleRMI;
import java.awt.Color;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.config.ConfigStyleSheet;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.gui.FontAttributes;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrintDeviceType;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinterNetwork;
import ordermate.database.hardware.physical.kts.KTSDocketPrinterQueries;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.hardware.physical.kts.KTSKeyMap;
import ordermate.database.hardware.physical.kts.KTSMilestone;
import ordermate.database.hardware.physical.kts.KTSModLines;
import ordermate.database.hardware.physical.kts.KTSProperty;
import ordermate.database.hardware.physical.kts.KTSPropertyType;
import ordermate.database.hardware.physical.kts.KTSShowTime;
import ordermate.database.hardware.physical.kts.KTSSummaryGroupingStrategyType;
import ordermate.database.hardware.physical.kts.KTSSummarySortingStrategyType;
import ordermate.database.hardware.physical.kts.keymap.DefaultKTSMapper;
import ordermate.database.hardware.physical.reboot.WindowsRebootable;
import ordermate.database.sales.Account;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="KTS_PRINTER")
@AccessType(value="property")
@AttributeOverride(name="label", column=@Column(name="Name"))
public class KTSDocketPrinter
extends PhysicalPrintDevice
implements WindowsRebootable {
    public static final int MAX_NUM_ROWS = 20;
    public static final int MAX_NUM_COLUMNS = 20;
    public static final Props Properties = new Props();
    private int numRows = 2;
    private int numColumns = 4;
    private String ipAddress = "localhost";
    private String userName = "";
    private Integer rmiPort;
    private KTSModLines modLines = KTSModLines.PerGroup;
    private KTSShowTime showTime = KTSShowTime.LiveOnly;
    private int autoCloseTime = 0;
    private int animTime = 0;
    private Color completedColour = Color.BLUE;
    private Color deletedColour = Color.RED;
    private Color transferColour = Color.GRAY;
    private boolean alternateColours = false;
    private Color alternatingColour1 = null;
    private Color alternatingColour2 = null;
    private Reference<FontAttributes> headerAttributes;
    private Reference<FontAttributes> courseAttributes;
    private Reference<FontAttributes> itemAttributes;
    private Reference<FontAttributes> optionsAttributes;
    private Reference<FontAttributes> plusAttributes;
    private Reference<FontAttributes> minusAttributes;
    private Reference<FontAttributes> notesAttributes;
    private Reference<FontAttributes> groupAttributes;
    private Reference<FontAttributes> summaryGroupAttributes;
    private Reference<FontAttributes> notifyAttributes;
    private Reference<FontAttributes> notifyItemsAttributes;
    private PersistentWriteableList<KTSMilestone> milestones;
    private PersistentWriteableList<KTSKeyMap> keyMaps;
    private PersistentWriteableList<KTSProperty> ktsProperties;
    private boolean enableSummaryPanel;
    private int summaryPanelColumns;
    private KTSSummarySortingStrategyType summaryItemSortStrategy;
    private KTSSummaryGroupingStrategyType summaryGroupStrategy;
    private String summaryItemGroupStrategy;
    private boolean summariseLiveQueue;
    private boolean summariseHoldQueue;
    private boolean summariseBumpedQueue;
    private boolean rushable;
    private boolean showStatusBar;
    private boolean webShowCustomerNames;
    private boolean webShowIcons;
    private boolean webShowOrderNumber;
    private boolean webShowOrderTime;
    private String webAppLocation;
    private int webAppPort;
    private int webNowReadyTimeout;
    private Reference<ConfigStyleSheet> redemptionStyleSheet;

    public KTSDocketPrinter() {
        this.headerAttributes = this.createReference(KTSDocketPrinter.Properties.HEADER_ATTRIBUTES);
        this.courseAttributes = this.createReference(KTSDocketPrinter.Properties.COURSE_ATTRIBUTES);
        this.itemAttributes = this.createReference(KTSDocketPrinter.Properties.ITEM_ATTRIBUTES);
        this.optionsAttributes = this.createReference(KTSDocketPrinter.Properties.OPTIONS_ATTRIBUTES);
        this.plusAttributes = this.createReference(KTSDocketPrinter.Properties.PLUS_ATTRIBUTES);
        this.minusAttributes = this.createReference(KTSDocketPrinter.Properties.MINUS_ATTRIBUTES);
        this.notesAttributes = this.createReference(KTSDocketPrinter.Properties.NOTES_ATTRIBUTES);
        this.groupAttributes = this.createReference(KTSDocketPrinter.Properties.GROUP_ATTRIBUTES);
        this.summaryGroupAttributes = this.createReference(KTSDocketPrinter.Properties.SUMMARY_GROUP_ATTRIBUTES);
        this.notifyAttributes = this.createReference(KTSDocketPrinter.Properties.NOTIFY_ATTRIBUTES);
        this.notifyItemsAttributes = this.createReference(KTSDocketPrinter.Properties.NOTIFY_ITEMS_ATTRIBUTES);
        this.milestones = this.createWriteableList(KTSDocketPrinter.Properties.MILESTONES);
        this.keyMaps = this.createWriteableList(KTSDocketPrinter.Properties.KEY_MAPS);
        this.ktsProperties = this.createWriteableList(KTSDocketPrinter.Properties.KTS_PROPERTIES);
        this.enableSummaryPanel = false;
        this.summaryPanelColumns = 1;
        this.summaryItemSortStrategy = KTSSummarySortingStrategyType.Name;
        this.summaryGroupStrategy = KTSSummaryGroupingStrategyType.None;
        this.summaryItemGroupStrategy = VirtualPrinter.PrepDocketGrouping.NONE.toString();
        this.summariseLiveQueue = true;
        this.summariseHoldQueue = false;
        this.summariseBumpedQueue = false;
        this.rushable = false;
        this.showStatusBar = true;
        this.webShowCustomerNames = true;
        this.webShowIcons = false;
        this.webShowOrderNumber = true;
        this.webShowOrderTime = true;
        this.webAppLocation = "C:/webapp";
        this.webAppPort = 8976;
        this.webNowReadyTimeout = 40;
        this.redemptionStyleSheet = this.createReference(KTSDocketPrinter.Properties.REDEMPTION_STYLE_SHEET);
    }

    public KTSDocketPrinter(Terminal yourHost) {
        this.headerAttributes = this.createReference(KTSDocketPrinter.Properties.HEADER_ATTRIBUTES);
        this.courseAttributes = this.createReference(KTSDocketPrinter.Properties.COURSE_ATTRIBUTES);
        this.itemAttributes = this.createReference(KTSDocketPrinter.Properties.ITEM_ATTRIBUTES);
        this.optionsAttributes = this.createReference(KTSDocketPrinter.Properties.OPTIONS_ATTRIBUTES);
        this.plusAttributes = this.createReference(KTSDocketPrinter.Properties.PLUS_ATTRIBUTES);
        this.minusAttributes = this.createReference(KTSDocketPrinter.Properties.MINUS_ATTRIBUTES);
        this.notesAttributes = this.createReference(KTSDocketPrinter.Properties.NOTES_ATTRIBUTES);
        this.groupAttributes = this.createReference(KTSDocketPrinter.Properties.GROUP_ATTRIBUTES);
        this.summaryGroupAttributes = this.createReference(KTSDocketPrinter.Properties.SUMMARY_GROUP_ATTRIBUTES);
        this.notifyAttributes = this.createReference(KTSDocketPrinter.Properties.NOTIFY_ATTRIBUTES);
        this.notifyItemsAttributes = this.createReference(KTSDocketPrinter.Properties.NOTIFY_ITEMS_ATTRIBUTES);
        this.milestones = this.createWriteableList(KTSDocketPrinter.Properties.MILESTONES);
        this.keyMaps = this.createWriteableList(KTSDocketPrinter.Properties.KEY_MAPS);
        this.ktsProperties = this.createWriteableList(KTSDocketPrinter.Properties.KTS_PROPERTIES);
        this.enableSummaryPanel = false;
        this.summaryPanelColumns = 1;
        this.summaryItemSortStrategy = KTSSummarySortingStrategyType.Name;
        this.summaryGroupStrategy = KTSSummaryGroupingStrategyType.None;
        this.summaryItemGroupStrategy = VirtualPrinter.PrepDocketGrouping.NONE.toString();
        this.summariseLiveQueue = true;
        this.summariseHoldQueue = false;
        this.summariseBumpedQueue = false;
        this.rushable = false;
        this.showStatusBar = true;
        this.webShowCustomerNames = true;
        this.webShowIcons = false;
        this.webShowOrderNumber = true;
        this.webShowOrderTime = true;
        this.webAppLocation = "C:/webapp";
        this.webAppPort = 8976;
        this.webNowReadyTimeout = 40;
        this.redemptionStyleSheet = this.createReference(KTSDocketPrinter.Properties.REDEMPTION_STYLE_SHEET);
        this.setPort("None");
        this.setHost(yourHost);
    }

    @Override
    public boolean canPrint(AbstractDocket docket) {
        return docket != null && "PREP".equals(docket.getDocketType());
    }

    @Override
    public void print(AbstractDocket docket, NotificationDetails notificationDetails) throws UnknownHostException, RemoteException, IOException {
        KTSDocketPrinterNetwork printerOnNetwork = null;
        IOException toThrow = null;
        try {
            InetAddress remoteAddress = InetAddress.getByName(this.getIpAddress());
            Remote remoteObject = SimpleRMI.getObject(remoteAddress, this.getLabel(), this.getRmiPort());
            printerOnNetwork = (KTSDocketPrinterNetwork)remoteObject;
        }
        catch (UnknownHostException ex) {
            OrderMateLog.LOG.error("KTSDocketPrinter couldn't resolve the remote address.", (Throwable)ex);
            toThrow = ex;
        }
        catch (RemoteException ex) {
            OrderMateLog.LOG.warn("Remote exception when binding KTSDocketPrinter.", (Throwable)ex);
            toThrow = ex;
        }
        catch (NotBoundException ex) {
            OrderMateLog.LOG.warn("NotBoundException when binding KTSDocketPrinter.", (Throwable)ex);
            toThrow = new IOException("*NotBoundException inside IOException*: ", ex);
        }
        if (printerOnNetwork != null) {
            printerOnNetwork.doPrint(docket, notificationDetails);
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public void changeKTSState(Account account, KTSDocketState oldState, KTSDocketState newState) {
        KTSDocketPrinterNetwork printerOnNetwork = null;
        try {
            InetAddress remoteAddress = InetAddress.getByName(this.getIpAddress());
            Remote remoteObject = SimpleRMI.getObject(remoteAddress, this.getLabel(), this.getRmiPort());
            printerOnNetwork = (KTSDocketPrinterNetwork)remoteObject;
        }
        catch (UnknownHostException ex) {
            OrderMateLog.LOG.error("KTDocketPrinter couldn't resolve the remote address.", (Throwable)ex);
        }
        catch (RemoteException ex) {
            OrderMateLog.LOG.warn("Remote exception when binding KTSDocketPrinter.", (Throwable)ex);
        }
        catch (NotBoundException ex) {
            OrderMateLog.LOG.warn("NotBoundException when binding KTSDocketPrinter.", (Throwable)ex);
        }
        if (printerOnNetwork != null) {
            try {
                printerOnNetwork.changeDocketState(account, oldState, newState);
            }
            catch (RemoteException ex) {
                OrderMate.LOG.warn("Cannot move dockets on KTS", (Throwable)ex);
            }
        }
    }

    @Override
    @Transient
    protected PhysicalPrintDeviceType getDeviceType() {
        return PhysicalPrintDeviceType.ktsPrinter;
    }

    public void setNumRows(int value) {
        if (value > 0 && value <= 20) {
            this.numRows = value;
        }
    }

    @Column(name="num_rows")
    public int getNumRows() {
        return this.numRows;
    }

    public void setNumColumns(int value) {
        if (value > 0 && value <= 20) {
            this.numColumns = value;
            if (this.summaryPanelColumns > this.numColumns - 1) {
                this.summaryPanelColumns = Math.max(this.numColumns - 1, 1);
            }
        }
    }

    @Column(name="num_columns")
    public int getNumColumns() {
        return this.numColumns;
    }

    @Column(name="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String value) {
        this.ipAddress = value;
    }

    @Column(name="rmi_port")
    public Integer getRmiPort() {
        if (this.rmiPort == null) {
            this.rmiPort = 11106;
        }
        return this.rmiPort;
    }

    public void setRmiPort(Integer value) {
        this.rmiPort = value;
    }

    @Column(name="user_name")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String value) {
        this.userName = value;
    }

    @Column(name="mod_lines")
    @Enumerated(value=EnumType.STRING)
    public KTSModLines getModLines() {
        return this.modLines;
    }

    public void setModLines(KTSModLines value) {
        this.modLines = value;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="show_time")
    public KTSShowTime getShowTime() {
        return this.showTime;
    }

    public void setShowTime(KTSShowTime value) {
        this.showTime = value;
    }

    @Column(name="auto_close_time")
    public int getAutoCloseTime() {
        return this.autoCloseTime;
    }

    public void setAutoCloseTime(int value) {
        this.autoCloseTime = value;
        if (this.autoCloseTime < 0) {
            this.autoCloseTime = 0;
        }
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_header", referencedColumnName="ID")
    public FontAttributes getHeaderAttributes() {
        return this.headerAttributes.get();
    }

    public void setHeaderAttributes(FontAttributes newAttributes) {
        this.headerAttributes.set(newAttributes);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_course", referencedColumnName="ID")
    public FontAttributes getCourseAttributes() {
        return this.courseAttributes.get();
    }

    public void setCourseAttributes(FontAttributes newAttributes) {
        this.courseAttributes.set(newAttributes);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_item", referencedColumnName="ID")
    public FontAttributes getItemAttributes() {
        return this.itemAttributes.get();
    }

    public void setItemAttributes(FontAttributes newAttributes) {
        this.itemAttributes.set(newAttributes);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_plus", referencedColumnName="ID")
    public FontAttributes getPlusAttributes() {
        return this.plusAttributes.get();
    }

    public void setPlusAttributes(FontAttributes newAttributes) {
        this.plusAttributes.set(newAttributes);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_minus", referencedColumnName="ID")
    public FontAttributes getMinusAttributes() {
        return this.minusAttributes.get();
    }

    public void setMinusAttributes(FontAttributes value) {
        this.minusAttributes.set(value);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_options", referencedColumnName="ID")
    public FontAttributes getOptionsAttributes() {
        return this.optionsAttributes.get();
    }

    public void setOptionsAttributes(FontAttributes value) {
        this.optionsAttributes.set(value);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_notes", referencedColumnName="ID")
    public FontAttributes getNotesAttributes() {
        return this.notesAttributes.get();
    }

    public void setNotesAttributes(FontAttributes value) {
        this.notesAttributes.set(value);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_group", referencedColumnName="ID")
    public FontAttributes getGroupAttributes() {
        if (this.groupAttributes.get() == null) {
            this.setGroupAttributes(KTSDocketPrinter.getDefaultSummaryGroupAttributes());
        }
        return this.groupAttributes.get();
    }

    public void setGroupAttributes(FontAttributes butes) {
        this.groupAttributes.set(butes);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_summary_group", referencedColumnName="ID")
    public FontAttributes getSummaryGroupAttributes() {
        if (this.summaryGroupAttributes.get() == null) {
            this.setSummaryGroupAttributes(KTSDocketPrinter.getDefaultSummaryGroupAttributes());
        }
        return this.summaryGroupAttributes.get();
    }

    public void setSummaryGroupAttributes(FontAttributes value) {
        this.summaryGroupAttributes.set(value);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_notify")
    public FontAttributes getNotifyAttributes() {
        if (this.notifyAttributes.isNull()) {
            this.setNotifyAttributes(new FontAttributes(14, Color.gray));
        }
        return this.notifyAttributes.get();
    }

    public void setNotifyAttributes(FontAttributes attributes) {
        this.notifyAttributes.set(attributes);
    }

    @ManyToOne(targetEntity=FontAttributes.class, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_font_attributes_notify_items")
    public FontAttributes getNotifyItemsAttributes() {
        if (this.notifyItemsAttributes.isNull()) {
            this.setNotifyItemsAttributes(new FontAttributes(12, Color.gray));
        }
        return this.notifyItemsAttributes.get();
    }

    public void setNotifyItemsAttributes(FontAttributes attributes) {
        this.notifyItemsAttributes.set(attributes);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="transfer_colour")
    public Color getTransferColour() {
        return this.transferColour;
    }

    public void setTransferColour(Color value) {
        this.transferColour = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="completed_colour")
    public Color getCompletedColour() {
        return this.completedColour;
    }

    public void setCompletedColour(Color value) {
        this.completedColour = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="deleted_colour")
    public Color getDeletedColour() {
        return this.deletedColour;
    }

    public void setDeletedColour(Color value) {
        this.deletedColour = value;
    }

    @Column(name="anim_time")
    public int getAnimTime() {
        return this.animTime;
    }

    public void setAnimTime(int value) {
        this.animTime = value;
    }

    @OneToMany(mappedBy="printer", targetEntity=KTSKeyMap.class)
    public List<KTSKeyMap> getKeyMaps() {
        return this.keyMaps;
    }

    protected void setKeyMaps(List<KTSKeyMap> maps) {
        this.keyMaps = this.keyMaps.clone();
        this.keyMaps.set(maps);
    }

    @Transient
    public List<KTSProperty> getKtsProperties() {
        return this.ktsProperties;
    }

    protected void setKtsProperties(List<KTSProperty> properties) {
        this.ktsProperties = this.ktsProperties.clone();
        this.ktsProperties.set(properties);
    }

    public KTSCommand getCommandForChar(int theChar, int modifiers) {
        for (KTSKeyMap nextMap : this.keyMaps) {
            if (nextMap.getKeyCode() == null || theChar != nextMap.getKeyCode() || nextMap.getModifier() != modifiers) continue;
            return nextMap.getCommand();
        }
        return null;
    }

    @OneToMany(mappedBy="printer", targetEntity=KTSMilestone.class)
    public List<KTSMilestone> getMilestones() {
        return this.milestones.getUnmodifiable();
    }

    protected void setMilestones(List<KTSMilestone> newKTSMilestones) {
        this.milestones = this.milestones.clone();
        this.milestones.set(newKTSMilestones);
    }

    public void addMilestone(KTSMilestone milestone) {
        if (milestone != null && this.equals(milestone.getPrinter()) && !this.milestones.contains(milestone)) {
            this.milestones.add(milestone);
        }
    }

    public void removeMilestone(KTSMilestone milestone) {
        if (milestone != null) {
            this.milestones.remove(milestone);
        }
    }

    @Column(name="enable_summary_panel")
    public boolean getEnableSummaryPanel() {
        return this.enableSummaryPanel;
    }

    public void setEnableSummaryPanel(boolean enableSummaryPanel) {
        this.enableSummaryPanel = enableSummaryPanel;
    }

    @Column(name="summary_panel_columns")
    public int getSummaryPanelColumns() {
        return this.summaryPanelColumns;
    }

    public void setSummaryPanelColumns(int columns) {
        this.summaryPanelColumns = columns;
    }

    @Column(name="summary_item_sort_strategy")
    @Enumerated(value=EnumType.STRING)
    public KTSSummarySortingStrategyType getSummaryItemSortStrategy() {
        return this.summaryItemSortStrategy;
    }

    public void setSummaryItemSortStrategy(KTSSummarySortingStrategyType sortingStrategy) {
        this.summaryItemSortStrategy = sortingStrategy;
    }

    @Column(name="summary_group_strategy")
    @Enumerated(value=EnumType.STRING)
    public KTSSummaryGroupingStrategyType getSummaryGroupStrategy() {
        return this.summaryGroupStrategy;
    }

    public void setSummaryGroupStrategy(KTSSummaryGroupingStrategyType groupingStrategy) {
        this.summaryGroupStrategy = groupingStrategy;
    }

    @Column(name="summary_item_group_strategy")
    public String getSummaryItemGroupStrategy() {
        return this.summaryItemGroupStrategy;
    }

    public void setSummaryItemGroupStrategy(String summaryItemGroupStrategy) {
        this.summaryItemGroupStrategy = summaryItemGroupStrategy;
    }

    @Column(name="summarise_live_queue")
    public boolean isSummariseLiveQueue() {
        return this.summariseLiveQueue;
    }

    public void setSummariseLiveQueue(boolean summariseLiveQueue) {
        this.summariseLiveQueue = summariseLiveQueue;
    }

    @Column(name="summarise_hold_queue")
    public boolean isSummariseHoldQueue() {
        return this.summariseHoldQueue;
    }

    public void setSummariseHoldQueue(boolean summariseHoldQueue) {
        this.summariseHoldQueue = summariseHoldQueue;
    }

    @Column(name="summarise_bumped_queue")
    public boolean isSummariseBumpedQueue() {
        return this.summariseBumpedQueue;
    }

    public void setSummariseBumpedQueue(boolean summariseBumpedQueue) {
        this.summariseBumpedQueue = summariseBumpedQueue;
    }

    @Column(name="rushable")
    public boolean isRushable() {
        return this.rushable;
    }

    public void setRushable(boolean value) {
        this.rushable = value;
    }

    @Column(name="show_status_bar")
    public boolean isShowStatusBar() {
        return this.showStatusBar;
    }

    public void setShowStatusBar(boolean value) {
        this.showStatusBar = value;
    }

    @Transient
    public Collection<KTSDocketState> getQueuesToSummarise() {
        ArrayList<KTSDocketState> states = new ArrayList<KTSDocketState>();
        if (this.summariseLiveQueue) {
            states.add(KTSDocketState.Live);
        }
        if (this.summariseHoldQueue) {
            states.add(KTSDocketState.Hold);
        }
        if (this.summariseBumpedQueue) {
            states.add(KTSDocketState.Bump);
        }
        return states;
    }

    @ManyToOne
    @JoinColumn(name="fk_redemption_stylesheet")
    public ConfigStyleSheet getRedemptionStyleSheet() {
        return this.redemptionStyleSheet.get();
    }

    public void setRedemptionStyleSheet(ConfigStyleSheet stylesheet) {
        this.redemptionStyleSheet.set(stylesheet);
    }

    @Override
    public void save() {
        this.headerAttributes.saveChild();
        this.courseAttributes.saveChild();
        this.itemAttributes.saveChild();
        this.optionsAttributes.saveChild();
        this.plusAttributes.saveChild();
        this.minusAttributes.saveChild();
        this.notesAttributes.saveChild();
        this.groupAttributes.saveChild();
        this.summaryGroupAttributes.saveChild();
        this.notifyAttributes.saveChild();
        this.notifyItemsAttributes.saveChild();
        this.milestones.saveChild();
        super.save();
        this.keyMaps.saveChild();
        this.ktsProperties.saveChild();
        this.addAllKeyMaps();
    }

    private void addAllKeyMaps() {
        ArrayList<KTSCommand> missingCommands = new ArrayList<KTSCommand>();
        boolean found = false;
        for (KTSCommand nextCommand : KTSCommand.values()) {
            found = false;
            for (KTSKeyMap nextMap : this.keyMaps) {
                if (!nextCommand.equals((Object)nextMap.getCommand())) continue;
                found = true;
            }
            if (found) continue;
            missingCommands.add(nextCommand);
        }
        for (KTSCommand command : missingCommands) {
            this.keyMaps.add(new KTSKeyMap(this, command));
        }
    }

    public static KTSDocketPrinter createDefaultKTSDocketPrinter(Terminal serverMateTerminal) {
        KTSDocketPrinter printer = new KTSDocketPrinter(serverMateTerminal);
        printer.setHeaderAttributes(new FontAttributes(16, null));
        printer.setCourseAttributes(new FontAttributes(16, Color.GRAY));
        printer.setItemAttributes(new FontAttributes(18, null));
        printer.setOptionsAttributes(new FontAttributes(16, Color.DARK_GRAY));
        printer.setPlusAttributes(new FontAttributes(16, new Color(100, 200, 100)));
        printer.setMinusAttributes(new FontAttributes(16, new Color(200, 100, 100)));
        printer.setNotesAttributes(new FontAttributes(16, Color.GRAY));
        printer.setNotifyAttributes(new FontAttributes(14, Color.GRAY));
        printer.setNotifyItemsAttributes(new FontAttributes(12, Color.GRAY));
        printer.setSummaryGroupAttributes(KTSDocketPrinter.getDefaultSummaryGroupAttributes());
        printer.setEnableSummaryPanel(false);
        printer.setSummaryPanelColumns(1);
        printer.setSummariseLiveQueue(true);
        printer.setSummariseHoldQueue(false);
        printer.setSummariseBumpedQueue(false);
        printer.setWebShowCustomerNames(true);
        printer.setWebShowIcons(false);
        printer.setWebShowOrderNumber(true);
        printer.setWebShowOrderTime(true);
        printer.setAnimTime(0);
        printer.setAutoCloseTime(5);
        printer.addAllKeyMaps();
        DefaultKTSMapper mapper = new DefaultKTSMapper();
        mapper.mapPrinter(printer);
        return printer;
    }

    private static FontAttributes getDefaultSummaryGroupAttributes() {
        return new FontAttributes(20, Color.BLACK, true, false);
    }

    public KTSProperty createKtsProperty(KTSPropertyType type, String key) {
        for (KTSProperty prop : this.ktsProperties) {
            if (!key.equals(prop.getKey()) || !type.equals((Object)prop.getType())) continue;
            return prop;
        }
        KTSProperty prop = new KTSProperty(this, type, key, null);
        this.ktsProperties.add(prop);
        return prop;
    }

    public void removeKtsProperty(KTSProperty prop) {
        this.ktsProperties.remove(prop);
    }

    @Transient
    public static List<KTSDocketPrinter> getAllActiveKTSDocketPrinters() {
        return KTSDocketPrinterQueries.getAllActiveKTSDocketPrinters();
    }

    @Transient
    public InetAddress getAddress() {
        if (this.ipAddress != null) {
            try {
                return InetAddress.getByName(this.ipAddress);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Transient
    public String getRebootableDeviceIPAddress() {
        return this.getIpAddress();
    }

    @Override
    @Transient
    public String getRebootableDeviceName() {
        return this.getLabel() + " (" + PhysicalPrintDeviceType.ktsPrinter.getLabel() + ")";
    }

    @Override
    @Transient
    public Integer getRebootableRMIPort() {
        return this.getRmiPort();
    }

    @Override
    @Transient
    public InetAddress getRebootableAddress() {
        return this.getAddress();
    }

    @Column(name="alternate_colours")
    public boolean getAlternateColours() {
        return this.alternateColours;
    }

    public void setAlternateColours(boolean alternateColours) {
        this.alternateColours = alternateColours;
    }

    @Column(name="web_show_customer_names")
    public boolean getWebShowCustomerNames() {
        return this.webShowCustomerNames;
    }

    public void setWebShowCustomerNames(boolean webShowCustomerNames) {
        this.webShowCustomerNames = webShowCustomerNames;
    }

    @Column(name="web_show_icons")
    public boolean getWebShowIcons() {
        return this.webShowIcons;
    }

    public void setWebShowIcons(boolean webShowIcons) {
        this.webShowIcons = webShowIcons;
    }

    @Column(name="web_show_order_number")
    public boolean getWebShowOrderNumber() {
        return this.webShowOrderNumber;
    }

    public void setWebShowOrderNumber(boolean webShowOrderNumber) {
        this.webShowOrderNumber = webShowOrderNumber;
    }

    @Column(name="web_show_order_time")
    public boolean getWebShowOrderTime() {
        return this.webShowOrderTime;
    }

    public void setWebShowOrderTime(boolean webShowOrderTime) {
        this.webShowOrderTime = webShowOrderTime;
    }

    @Column(name="web_app_location")
    public String getWebAppLocation() {
        return this.webAppLocation;
    }

    public void setWebAppLocation(String webAppLocation) {
        this.webAppLocation = webAppLocation;
    }

    @Column(name="web_app_port")
    public int getWebAppPort() {
        return this.webAppPort;
    }

    public void setWebAppPort(int webAppPort) {
        this.webAppPort = webAppPort;
    }

    @Column(name="web_now_ready_timeout")
    public int getWebNowReadyTimeout() {
        return this.webNowReadyTimeout;
    }

    public void setWebNowReadyTimeout(int webNowReadyTimeout) {
        this.webNowReadyTimeout = webNowReadyTimeout;
    }

    @Column(name="alternating_colour_1")
    public Color getAlternatingColour1() {
        return this.alternatingColour1;
    }

    public void setAlternatingColour1(Color alternatingColour1) {
        this.alternatingColour1 = alternatingColour1;
    }

    @Column(name="alternating_colour_2")
    public Color getAlternatingColour2() {
        return this.alternatingColour2;
    }

    public void setAlternatingColour2(Color alternatingColour2) {
        this.alternatingColour2 = alternatingColour2;
    }

    public static class Props
    extends PhysicalPrintDevice.Props {
        public PropertiedObject.Property NUM_ROWS;
        public PropertiedObject.Property NUM_COLUMNS;
        public PropertiedObject.Property<String> IP_ADDRESS;
        public PropertiedObject.Property<String> USER_NAME;
        public PropertiedObject.Property<Integer> RMI_PORT;
        public PropertiedObject.Property<KTSModLines> MOD_LINES;
        public PropertiedObject.Property<Boolean> RUSHABLE;
        public PropertiedObject.Property<KTSShowTime> SHOW_TIME;
        public PropertiedObject.Property AUTO_CLOSE_TIME;
        public PropertiedObject.Property ANIM_TIME;
        public PropertiedObject.Property<Color> COMPLETED_COLOUR;
        public PropertiedObject.Property<Color> DELETED_COLOUR;
        public PropertiedObject.Property<Color> TRANSFER_COLOUR;
        public PropertiedObject.Property<Boolean> ALTERNATE_COLOURS;
        public PropertiedObject.Property<Color> ALTERNATING_COLOUR_1;
        public PropertiedObject.Property<Color> ALTERNATING_COLOUR_2;
        public PropertiedObject.Property<FontAttributes> HEADER_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> COURSE_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> ITEM_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> OPTIONS_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> PLUS_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> MINUS_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> NOTES_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> GROUP_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> SUMMARY_GROUP_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> NOTIFY_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> NOTIFY_ITEMS_ATTRIBUTES;
        public PropertiedObject.Property<KTSMilestone> MILESTONES;
        public PropertiedObject.Property<KTSKeyMap> KEY_MAPS;
        public PropertiedObject.Property<KTSProperty> KTS_PROPERTIES;
        public PropertiedObject.Property<Boolean> WEB_SHOW_CUSTOMER_NAMES;
        public PropertiedObject.Property<Boolean> WEB_SHOW_ICONS;
        public PropertiedObject.Property<Boolean> WEB_SHOW_ORDER_NUMBER;
        public PropertiedObject.Property<Boolean> WEB_SHOW_ORDER_TIME;
        public PropertiedObject.Property<String> WEB_APP_LOCATION;
        public PropertiedObject.Property<Long> WEB_APP_PORT;
        public PropertiedObject.Property<Integer> WEB_NOW_READY_TIMEOUT;
        public PropertiedObject.Property<Boolean> ENABLE_SUMMARY_PANEL;
        public PropertiedObject.Property<Integer> SUMMARY_PANEL_COLUMNS;
        public PropertiedObject.Property<KTSSummarySortingStrategyType> SUMMARY_ITEM_SORT_STRATEGY;
        public PropertiedObject.Property<KTSSummaryGroupingStrategyType> SUMMARY_GROUP_STRATEGY;
        public PropertiedObject.Property<String> SUMMARY_ITEM_GROUP_STRATEGY;
        public PropertiedObject.Property<Boolean> SUMMARISE_LIVE_QUEUE;
        public PropertiedObject.Property<Boolean> SUMMARISE_HOLD_QUEUE;
        public PropertiedObject.Property<Boolean> SUMMARISE_BUMPED_QUEUE;
        public PropertiedObject.Property<ConfigStyleSheet> REDEMPTION_STYLE_SHEET;
        public PropertiedObject.Property<Boolean> SHOW_STATUS_BAR;
    }
}

