/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.awt.event.KeyEvent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;

@Entity
@Table(name="config_kts_key_map")
public class KTSKeyMap
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<KTSDocketPrinter> printer;
    private KTSCommand command;
    private Integer keyCode;
    private int modifier;
    private String stroke;

    @Deprecated
    public KTSKeyMap() {
        this.printer = this.createReference(KTSKeyMap.Properties.PRINTER);
        this.modifier = 0;
        this.stroke = null;
    }

    public KTSKeyMap(KTSDocketPrinter printer, KTSCommand yourCommand) {
        this.printer = this.createReference(KTSKeyMap.Properties.PRINTER);
        this.modifier = 0;
        this.stroke = null;
        this.setPrinter(printer);
        this.setKeyCode(null);
        this.setModifier(0);
        this.setCommand(yourCommand);
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="fk_config_printer", referencedColumnName="ID")
    public KTSDocketPrinter getPrinter() {
        return this.printer.get();
    }

    protected void setPrinter(KTSDocketPrinter yourPrinter) {
        this.printer.set(yourPrinter);
    }

    @Column(name="key_code")
    public Integer getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(Integer value) {
        this.keyCode = value;
        this.stroke = null;
    }

    @Column(name="command")
    @Enumerated(value=EnumType.STRING)
    public KTSCommand getCommand() {
        return this.command;
    }

    protected void setCommand(KTSCommand value) {
        if (value != null) {
            this.command = value;
        }
    }

    @Transient
    public String getStroke() {
        if (this.stroke == null) {
            StringBuilder SB = new StringBuilder();
            if (this.modifier > 0) {
                SB.append(KeyEvent.getKeyModifiersText(this.modifier)).append(" + ");
            }
            if (this.keyCode == null) {
                SB.append("<none>");
            } else {
                SB.append(KeyEvent.getKeyText(this.keyCode));
            }
            this.stroke = SB.toString();
        }
        return this.stroke;
    }

    @Column(name="modifier")
    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int value) {
        this.modifier = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Integer> KEY_CODE;
        public PropertiedObject.Property MODIFIER;
        public PropertiedObject.Property<KTSCommand> COMMAND;
        public PropertiedObject.Property<KTSDocketPrinter> PRINTER;
        public PersistentObject.DerivedProperty<String> STROKE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KTSKeyMap.class), "stroke");
    }
}

