/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSMilestoneAction;
import ordermate.database.hardware.physical.kts.KTSMilestoneInclude;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_kts_milestone")
@AccessType(value="property")
public class KTSMilestone
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String name = "New Milestone";
    private int seconds = 0;
    private int lineThickness = 3;
    private Color colour = Color.RED;
    private KTSMilestoneAction action = KTSMilestoneAction.Flash;
    private KTSMilestoneInclude include = KTSMilestoneInclude.TotalTime;
    private Reference<KTSDocketPrinter> printer;

    public KTSMilestone() {
        this.printer = this.createReference(KTSMilestone.Properties.PRINTER);
    }

    public KTSMilestone(KTSDocketPrinter yourPrinter) {
        this.printer = this.createReference(KTSMilestone.Properties.PRINTER);
        this.setPrinter(yourPrinter);
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setSeconds(int value) {
        this.seconds = value;
    }

    @Column(name="seconds")
    public int getSeconds() {
        return this.seconds;
    }

    @Column(name="line_thickness")
    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int value) {
        this.lineThickness = value;
    }

    @Column(name="colour")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color value) {
        this.colour = value;
    }

    @Column(name="action")
    @Enumerated(value=EnumType.STRING)
    public KTSMilestoneAction getAction() {
        return this.action;
    }

    public void setAction(KTSMilestoneAction value) {
        this.action = value;
    }

    @Column(name="include")
    @Enumerated(value=EnumType.STRING)
    public KTSMilestoneInclude getInclude() {
        return this.include;
    }

    public void setInclude(KTSMilestoneInclude value) {
        this.include = value;
    }

    @ManyToOne(targetEntity=KTSDocketPrinter.class)
    @JoinColumn(name="fk_config_printer", referencedColumnName="ID")
    public KTSDocketPrinter getPrinter() {
        return this.printer.get();
    }

    protected void setPrinter(KTSDocketPrinter newPrinter) {
        this.printer.set(newPrinter);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property SECONDS;
        public PropertiedObject.Property<Color> COLOUR;
        public PropertiedObject.Property<KTSMilestoneAction> ACTION;
        public PropertiedObject.Property<KTSMilestoneInclude> INCLUDE;
        public PropertiedObject.Property LINE_THICKNESS;
        public PropertiedObject.Property<KTSDocketPrinter> PRINTER;
    }
}

