/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.sales.AccountType;

public class KTSProperties {
    public static final String HEADER_ACCOUNT_NAME = "Header Account Name ";
    public static final String HEADER_ACCOUNT_NUM = "Header Account Number";
    public static final String HEADER_ORDER_NUMBER = "Header Order Number ";
    public static final String HEADER_CUSTOMER_INFO = "Header Customer Info";
    public static final String CUSTOMER_NAME = "Customer Name";
    public static final String HEADER_USER_NAME = "Header User Name";
    public static final String HEADER_TIME_DUE = "Header Time Due";
    public static final String HEADER_ETA = "Header ETA";
    public static final String GROUP_HEADER = "Group Header";
    public static final String COMBO_SHORT_NAME = "Combo Short Name";
    public static final String TICKET_DATA_NAME = "Ticket Data Name";
    public static final String HEADER_EXTERNAL_ORDER_REF = "Header Order External Ref";
    public static final String HEADER_EXTERNAL_ORDER_ALT_REF = "Header Order Alternate Ref";
    public static final String TRANSFER_DOCKET = "Transfer Docket";
    public static final String DELETE_DOCKET = "Delete Docket";

    private KTSProperties() {
    }

    public static List<String> getAllProperties() {
        ArrayList<String> props = new ArrayList<String>();
        for (Field field : KTSProperties.class.getFields()) {
            int mods = field.getModifiers();
            if (!String.class.equals(field.getType()) || !field.getDeclaringClass().equals(KTSProperties.class) || !Modifier.isFinal(mods) || !Modifier.isStatic(mods)) continue;
            try {
                props.add((String)field.get(null));
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot access field " + field, (Throwable)ex);
            }
        }
        props.remove(HEADER_ACCOUNT_NAME);
        for (AccountType accountType : AccountType.register.values()) {
            props.add(HEADER_ACCOUNT_NAME + accountType.getType());
        }
        props.remove(HEADER_ORDER_NUMBER);
        for (AccountType accountType : AccountType.register.values()) {
            props.add(HEADER_ORDER_NUMBER + accountType.getType());
        }
        props.add(HEADER_ORDER_NUMBER + AccountType.allType.getType());
        return props;
    }
}

