/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts.keymap;

import java.util.HashMap;
import java.util.Map;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSKeyMap;

public abstract class KTSKeyMapper {
    private Map<KTSCommand, KeyModPair> map = new HashMap<KTSCommand, KeyModPair>();

    public KTSKeyMapper() {
        this.fillMap(this.map);
    }

    protected abstract void fillMap(Map<KTSCommand, KeyModPair> var1);

    public void mapPrinter(KTSDocketPrinter printer) {
        for (KTSKeyMap nextKeyMap : printer.getKeyMaps()) {
            nextKeyMap.setKeyCode(this.getKeyFor(nextKeyMap.getCommand()));
            nextKeyMap.setModifier(this.getModFor(nextKeyMap.getCommand()));
        }
    }

    public Integer getKeyFor(KTSCommand command) {
        return this.map.get((Object)((Object)command)).key;
    }

    public int getModFor(KTSCommand command) {
        return this.map.get((Object)((Object)command)).mod;
    }

    class KeyModPair {
        Integer key;
        int mod;

        KeyModPair(Integer keyValue, int modValue) {
            this.key = keyValue;
            this.mod = modValue;
        }
    }
}

