/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.hardware.physical.kts.keymap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.keymap.DefaultKTSMapper;
import ordermate.database.hardware.physical.kts.keymap.KTSKeyMapper;
import ordermate.database.hardware.physical.kts.keymap.MPadKeyMapper;
import ordermate.database.hardware.physical.kts.keymap.OrderMateMkIMapper;
import ordermate.database.hardware.physical.kts.keymap.PosiflexBB2000KeyMapper;

public class KTSKeyMapperFactory {
    private static final List<String> availables = new ArrayList<String>();

    private KTSKeyMapperFactory() {
    }

    public static List<String> getAvailableMaps() {
        return Collections.unmodifiableList(availables);
    }

    public static void configureFor(KTSDocketPrinter printer, String mapperName) {
        KTSKeyMapper mapper;
        if (availables.get(0).equals(mapperName)) {
            mapper = new DefaultKTSMapper();
        } else if (availables.get(1).equals(mapperName)) {
            mapper = new PosiflexBB2000KeyMapper();
        } else if (availables.get(2).equals(mapperName)) {
            mapper = new MPadKeyMapper();
        } else if (availables.get(3).equals(mapperName)) {
            mapper = new OrderMateMkIMapper();
        } else {
            throw new IllegalArgumentException("Unknown mapper for:" + mapperName);
        }
        mapper.mapPrinter(printer);
    }

    static {
        availables.add("Default");
        availables.add("Posiflex BB 2000");
        availables.add("M-Pad");
        availables.add("OrderMate MkI");
    }
}

