/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_ext_id")
@AccessType(value="property")
@DiscriminatorColumn(name="referenced_type")
@MappedSuperclass
public abstract class AbstractIntegrationExtID
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Long externalID;
    private IntegrationExtIDType integrationType;

    AbstractIntegrationExtID() {
    }

    public AbstractIntegrationExtID(IntegrationExtIDType integrationType) {
        this.integrationType = integrationType;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="ext_id")
    public Long getExternalID() {
        return this.externalID;
    }

    public void setExternalID(Long externalID) {
        this.externalID = externalID;
    }

    @Column(name="integration_type")
    @Enumerated(value=EnumType.STRING)
    public IntegrationExtIDType getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(IntegrationExtIDType integrationType) {
        this.integrationType = integrationType;
    }

    @Transient
    public String getReferencedLabel() {
        if (this.getReferencedObject() != null) {
            return this.getReferencedObject().toString();
        }
        return "";
    }

    @Transient
    public abstract PersistentObject getReferencedObject();

    public abstract void setReferencedObject(PersistentObject var1);

    @Transient
    public abstract PropertiedObject.Property getReferencedProperty();

    @Transient
    public abstract PropertiedObject.Property getReferencedPropertyID();

    @Transient
    public abstract Class getReferencedType();

    public static enum ReferencedExtIDType {
        TERMINAL,
        USER;

        public static final Map<String, ReferencedExtIDType> register;

        static {
            register = PersistentEnumeration.buildRegister(ReferencedExtIDType.values());
        }
    }

    public static enum IntegrationExtIDType {
        IGT;

        public static final Map<String, IntegrationExtIDType> register;

        static {
            register = PersistentEnumeration.buildRegister(IntegrationExtIDType.values());
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Long> EXTERNAL_ID;
        public PropertiedObject.Property<IntegrationExtIDType> INTEGRATION_TYPE;
    }
}

