/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.reference.SingletonReference;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.inventory.PriceLevel;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_barstock")
@AccessType(value="property")
@DBMapping(value=DBMapping.Mapping.Row)
public class BarStockConfiguration
extends PersistentObject {
    public static final Props Properties = new Props();
    private static final String START = "REMOTE_START";
    private static final String STOP = "REMOTE_STOP";
    private static final String CRASH = "REMOTE_CRASH";
    private static Reference instance = new SingletonReference<BarStockConfiguration>(BarStockConfiguration.class);
    private Reference<PriceLevel> priceLevel;
    private String workingDirectoryPath;
    private String inputFileName;
    private String outputFileName;
    private String itemPluFileName;
    private String server;
    private int port;

    @ManyToOne
    @JoinColumn(name="Price Level", referencedColumnName="ID")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    @Column(name="File Path")
    public String getWorkingDirectoryPath() {
        return this.workingDirectoryPath;
    }

    @Column(name="Input File")
    public String getInputFileName() {
        return this.inputFileName;
    }

    @Column(name="Output File")
    public String getOutputFileName() {
        return this.outputFileName;
    }

    @Column(name="PLU File")
    public String getItemPluFileName() {
        return this.itemPluFileName;
    }

    @Column(name="Barstock Machine IP Address")
    public String getServer() {
        return this.server;
    }

    @Column(name="Port")
    public int getPort() {
        return this.port;
    }

    public void remoteStart() throws IOException {
        this.sendRemoteCommand(START);
    }

    public void remoteStop() throws IOException {
        this.sendRemoteCommand(STOP);
    }

    public void remoteCrash() throws IOException {
        this.sendRemoteCommand(CRASH);
    }

    private void sendRemoteCommand(String command) throws IOException {
        InetAddress barstockAddress = InetAddress.getByName(this.getServer());
        int portNumber = this.getPort();
        Socket serverConnection = new Socket(barstockAddress, portNumber);
        OutputStream output = serverConnection.getOutputStream();
        PrintWriter writer = new PrintWriter(output);
        writer.print(command);
        writer.flush();
        serverConnection.close();
    }

    public static BarStockConfiguration getInstance() {
        return (BarStockConfiguration)instance.get();
    }

    public void setItemPluFileName(String newItemPluFileName) {
        this.itemPluFileName = newItemPluFileName;
    }

    public void setPriceLevel(PriceLevel newPriceLevel) {
        this.priceLevel.set(newPriceLevel);
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    public void setInputFileName(String newInputFileName) {
        this.inputFileName = newInputFileName;
    }

    public void setWorkingDirectoryPath(String newWorkingDirectoryPath) {
        this.workingDirectoryPath = newWorkingDirectoryPath;
    }

    public void setServer(String newServer) {
        this.server = newServer;
    }

    public void setOutputFileName(String newOutputFileName) {
        this.outputFileName = newOutputFileName;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> WORKING_DIRECTORY_PATH;
        public PropertiedObject.Property<String> INPUT_FILE_NAME;
        public PropertiedObject.Property<String> OUTPUT_FILE_NAME;
        public PropertiedObject.Property<String> ITEM_PLU_FILE_NAME;
        public PropertiedObject.Property<String> SERVER;
        public PropertiedObject.Property PORT;
        public PropertiedObject.Property<PriceLevel> PRICE_LEVEL;
    }
}

