/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.AbstractIntegrationExtID;

public class IntegrationExtIDHelper {
    public static <T extends AbstractIntegrationExtID> T getExtIDFor(Class<T> extIDtype, AbstractIntegrationExtID.IntegrationExtIDType integrationType, PersistentObject refObj) {
        try {
            AbstractIntegrationExtID extID = (AbstractIntegrationExtID)extIDtype.newInstance();
            ObjectQuery query = Query.select(extIDtype).equals(AbstractIntegrationExtID.Properties.INTEGRATION_TYPE, (Object)integrationType).equals(extID.getReferencedProperty(), refObj);
            return (T)((AbstractIntegrationExtID)PersistenceManager.getObject(extIDtype, query.toString(), null));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("IntegrationExtIDHelper error :", (Throwable)ex);
            return null;
        }
    }

    public static <T extends AbstractIntegrationExtID> List<T> getAllExtIDFor(Class<T> extIDtype, AbstractIntegrationExtID.IntegrationExtIDType integrationType, boolean includeAll) {
        try {
            AbstractIntegrationExtID extIDInstance = (AbstractIntegrationExtID)extIDtype.newInstance();
            ObjectQuery query = Query.select(extIDtype).equals(AbstractIntegrationExtID.Properties.INTEGRATION_TYPE, (Object)integrationType).not().isNull(extIDInstance.getReferencedProperty());
            List<T> result = PersistenceManager.getObjectList(extIDtype, query.toString());
            if (includeAll) {
                IntegrationExtIDHelper.addAllMissingReferences(extIDtype, integrationType, result);
            }
            return result;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("IntegrationExtIDHelper error :", (Throwable)ex);
            return new ArrayList();
        }
    }

    private static <T extends AbstractIntegrationExtID> void addAllMissingReferences(Class<T> extIDType, AbstractIntegrationExtID.IntegrationExtIDType integrationType, List<T> extIDList) {
        try {
            AbstractIntegrationExtID extIDInstance = (AbstractIntegrationExtID)extIDType.newInstance();
            ObjectQuery query = Query.select(extIDInstance.getReferencedType()).active(extIDInstance.getReferencedType());
            if (!extIDList.isEmpty()) {
                query = query.not().wherePropertyIn(extIDInstance.getReferencedPropertyID(), IntegrationExtIDHelper.getAllReferencesLinked(extIDList));
            }
            List<PersistentObject> allUsers = PersistenceManager.getObjectList(extIDInstance.getReferencedType(), query.toString());
            for (PersistentObject referencedItem : allUsers) {
                AbstractIntegrationExtID newExternalID = (AbstractIntegrationExtID)extIDType.newInstance();
                newExternalID.setIntegrationType(integrationType);
                newExternalID.setReferencedObject(referencedItem);
                extIDList.add(newExternalID);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("IntegrationExtIDHelper error :", (Throwable)ex);
        }
    }

    public static <T extends AbstractIntegrationExtID> void saveAndDelete(List<T> extIDList) {
        for (AbstractIntegrationExtID extID : extIDList) {
            if (extID.getReferencedObject() == null || extID.getExternalID() == null) {
                if (!extID.isPersistent()) continue;
                extID.delete();
                continue;
            }
            extID.save();
        }
    }

    private static <T extends AbstractIntegrationExtID> List<PersistentObject> getAllReferencesLinked(List<T> extIDList) {
        ArrayList<PersistentObject> result = new ArrayList<PersistentObject>();
        for (AbstractIntegrationExtID extID : extIDList) {
            result.add(extID.getReferencedObject());
        }
        return result;
    }
}

