/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockSupplier;

public class InvoiceIntegrationConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private InvoiceIntegrationType type = InvoiceIntegrationType.ALM;
    private String customerNo;
    private Reference<StockArea> stockArea;
    private Reference<StockSupplier> supplier;
    private String defaultFilePath;

    public InvoiceIntegrationConfig() {
        this.stockArea = this.createReference(InvoiceIntegrationConfig.Properties.STOCK_AREA);
        this.supplier = this.createReference(InvoiceIntegrationConfig.Properties.SUPPLIER);
    }

    public InvoiceIntegrationConfig(InvoiceIntegrationType type) {
        this.stockArea = this.createReference(InvoiceIntegrationConfig.Properties.STOCK_AREA);
        this.supplier = this.createReference(InvoiceIntegrationConfig.Properties.SUPPLIER);
        this.setType(type);
    }

    public InvoiceIntegrationType getType() {
        return this.type;
    }

    protected void setType(InvoiceIntegrationType type) {
        this.type = type;
    }

    public String getCustomerNo() {
        return this.customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public StockArea getStockArea() {
        return this.stockArea.get();
    }

    public void setStockArea(StockArea stockArea) {
        this.stockArea.set(stockArea);
    }

    public StockSupplier getSupplier() {
        return this.supplier.get();
    }

    public void setSupplier(StockSupplier supplier) {
        this.supplier.set(supplier);
    }

    public String getDefaultFilePath() {
        return this.defaultFilePath;
    }

    public void setDefaultFilePath(String defaultFilePath) {
        this.defaultFilePath = defaultFilePath;
    }

    public static InvoiceIntegrationConfig getConfigForType(InvoiceIntegrationType type) {
        ObjectQuery query = Query.select(InvoiceIntegrationConfig.class).equals(InvoiceIntegrationConfig.Properties.TYPE, (Object)type).limit(1);
        InvoiceIntegrationConfig result = PersistenceManager.getObject(InvoiceIntegrationConfig.class, query.toString(), null);
        if (result == null) {
            result = new InvoiceIntegrationConfig(type);
        }
        return result;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.type.name();
    }

    public static enum InvoiceIntegrationType {
        ALM,
        LightYear,
        InvitBox;

    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InvoiceIntegrationType> TYPE;
        public PropertiedObject.Property CUSTOMER_NO;
        public PropertiedObject.Property<StockArea> STOCK_AREA;
        public PropertiedObject.Property<StockSupplier> SUPPLIER;
        public PropertiedObject.Property DEFAULT_FILE_PATH;
    }
}

