/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.reference.SingletonReference;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_loyalty")
@AccessType(value="property")
@DBMapping(value=DBMapping.Mapping.Row)
public class LoyaltyIntegrationConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private static final int MAX_TRANSACTION_NUMBER = 99999999;
    private static final String SELECT_TRANS_NO_QUERY = "SELECT value FROM config_integration_loyalty WHERE name = 'Transaction_Number'";
    private static final String UPDATE_TRANS_NO_QUERY = "UPDATE config_integration_loyalty SET value = ? WHERE name = 'Transaction_Number'";
    private static final String INSERT_TRANS_NO_QUERY = "INSERT INTO config_integration_loyalty (name, value) VALUES ('Transaction_Number', ?)";
    private LoyaltyIntegrationType type;
    private String serverIPAddress;
    private int serverPort;
    private String accessKey;
    private boolean canModifyRatios;
    private String defaultTerminal;
    private String defaultAttendant;
    private int memberNumberLength;
    private String username;
    private String password;
    private static final Reference<LoyaltyIntegrationConfig> instance = new SingletonReference<LoyaltyIntegrationConfig>(LoyaltyIntegrationConfig.class);

    @Transient
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Transient
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static final LoyaltyIntegrationConfig getInstance() {
        return instance.get();
    }

    public static void collapseReference() {
        if (instance != null) {
            instance.collapse();
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            throw new IllegalStateException("LoyaltyIntegrationConfig is a Singleton so a new instance must not be created.");
        }
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Cannot remove single instance of LoyaltyIntegrationConfig.");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="Integration Type")
    @Enumerated(value=EnumType.STRING)
    public LoyaltyIntegrationType getType() {
        return this.type;
    }

    public void setType(LoyaltyIntegrationType type) {
        this.type = type;
    }

    @Column(name="Server IP Address")
    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public void setServerIPAddress(String serverIPAddress) {
        this.serverIPAddress = serverIPAddress;
    }

    @Column(name="Server Port")
    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    @Column(name="Access Key")
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Column(name="User Can Modify Ratios")
    public boolean isCanModifyRatios() {
        return this.canModifyRatios;
    }

    public void setCanModifyRatios(boolean canModifyRatios) {
        this.canModifyRatios = canModifyRatios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transient
    public Integer getNextTransactionNumber() {
        LoyaltyIntegrationConfig loyaltyIntegrationConfig = this;
        synchronized (loyaltyIntegrationConfig) {
            int transNum = 1;
            Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(SELECT_TRANS_NO_QUERY, null);
            if (result.length == 0) {
                PersistenceManager.getPersistenceDelegate().executeInsert(INSERT_TRANS_NO_QUERY, new Object[]{1});
            } else {
                transNum = Integer.parseInt((String)result[0][0]);
                transNum = transNum == 99999999 ? 1 : ++transNum;
                PersistenceManager.getPersistenceDelegate().executeUpdate(UPDATE_TRANS_NO_QUERY, new Object[]{transNum});
            }
            return transNum;
        }
    }

    @Column(name="Default_Terminal")
    public String getDefaultTerminal() {
        return this.defaultTerminal;
    }

    public void setDefaultTerminal(String defaultTerminal) {
        this.defaultTerminal = defaultTerminal;
    }

    @Column(name="Default_Attendant")
    public String getDefaultAttendant() {
        return this.defaultAttendant;
    }

    public void setDefaultAttendant(String defaultAttendant) {
        this.defaultAttendant = defaultAttendant;
    }

    @Column(name="member_length")
    public int getMemberNumberLength() {
        return this.memberNumberLength;
    }

    public void setMemberNumberLength(int memberNumberLength) {
        this.memberNumberLength = memberNumberLength;
    }

    public static enum LoyaltyIntegrationType {
        HO,
        IGT,
        TRAC;

        public static final Map<String, LoyaltyIntegrationType> register;

        public static final Map<String, LoyaltyIntegrationType> getRegister() {
            return register;
        }

        static {
            register = new HashMap<String, LoyaltyIntegrationType>();
            for (LoyaltyIntegrationType group : LoyaltyIntegrationType.values()) {
                register.put(group.toString(), group);
            }
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<LoyaltyIntegrationType> TYPE;
        public PropertiedObject.Property SERVER_IP_ADDRESS;
        public PropertiedObject.Property SERVER_PORT;
        public PropertiedObject.Property ACCESS_KEY;
        public PropertiedObject.Property CAN_MODIFY_RATIOS;
        public PropertiedObject.Property DEFAULT_TERMINAL;
        public PropertiedObject.Property DEFAULT_ATTENDANT;
        public PropertiedObject.Property MEMBER_NUMBER_LENGTH;
        public PropertiedObject.Property USERNAME;
        public PropertiedObject.Property PASSWORD;
    }
}

