/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.reference.SingletonReference;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.integration.restaurantdiary.RDBookingSyncRescheduler;
import ordermate.integration.webservice.OAuthMapBuilder;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_restaurantdiary")
@AccessType(value="property")
@DBMapping(value=DBMapping.Mapping.Row)
public class RDConfiguration
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private static final Reference<RDConfiguration> instance = new SingletonReference<RDConfiguration>(RDConfiguration.class);
    private String key;
    private String secret;
    private String secondSecret;
    private Integer restaurantId;
    private String webserviceUrl;
    private String scopeUrl;
    private String oauthEndpoint;
    private Integer syncFrequency;
    private Integer syncPlusTime;
    private Integer syncMinusTime;
    public static final Integer DEFAULT_SYNC_PLUS_TIME = 720;
    public static final Integer DEFAULT_SYNC_MINUS_TIME = 60;
    public static final Integer DEFAULT_SYNC_FREQUENCY = 30;

    public static RDConfiguration getInstance() {
        return instance.get();
    }

    @Column(name="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Column(name="secret")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String newSecret) {
        this.secret = newSecret;
    }

    @Column(name="second_secret")
    public String getSecondSecret() {
        return this.secondSecret;
    }

    public void setSecondSecret(String secSecret) {
        this.secondSecret = secSecret;
    }

    @Column(name="restaurant_id")
    public Integer getRestaurantId() {
        return this.restaurantId;
    }

    public void setRestaurantId(Integer restaurantId) {
        this.restaurantId = restaurantId;
    }

    @Column(name="webservice_url")
    public String getWebserviceUrl() {
        return this.webserviceUrl;
    }

    public void setWebserviceUrl(String url) {
        this.webserviceUrl = url;
    }

    @Column(name="scope_url")
    public String getScopeUrl() {
        return this.scopeUrl;
    }

    public void setScopeUrl(String url) {
        this.scopeUrl = url;
    }

    @Column(name="oauth_endpoint")
    public String getOauthEndpoint() {
        return this.oauthEndpoint;
    }

    public void setOauthEndpoint(String oAuthEnd) {
        this.oauthEndpoint = oAuthEnd;
    }

    @Column(name="sync_frequency")
    public Integer getSyncFrequency() {
        return this.syncFrequency != null ? this.syncFrequency : DEFAULT_SYNC_FREQUENCY;
    }

    public void setSyncFrequency(Integer value) {
        this.syncFrequency = value;
    }

    @Column(name="sync_plus_time")
    public Integer getSyncPlusTime() {
        return this.syncPlusTime != null ? this.syncPlusTime : DEFAULT_SYNC_PLUS_TIME;
    }

    public void setSyncPlusTime(Integer value) {
        this.syncPlusTime = value;
    }

    @Column(name="sync_minus_time")
    public Integer getSyncMinusTime() {
        return this.syncMinusTime != null ? this.syncMinusTime : DEFAULT_SYNC_MINUS_TIME;
    }

    public void setSyncMinusTime(Integer value) {
        this.syncMinusTime = value;
    }

    public static boolean checkConfigured() {
        return ReservationIntegrationType.RESTAURANTDIARY.equals((Object)SystemProperty.getInstance().getReservationIntegration());
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            throw new IllegalStateException("RestaurantdiaryConfiguration is a Singleton so a new instance must not be created.");
        }
        PersistenceManager.save(this);
        RDConfiguration.clearCache();
        PersistenceManager.getServerConnection().runSync(new RDBookingSyncRescheduler());
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Cannot remove single instance of RestaurantdiaryConfiguration.");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static OAuthMapBuilder getBuilder() {
        OAuthMapBuilder builder = new OAuthMapBuilder();
        builder.addKey(RDConfiguration.getInstance().getKey()).addSecret(RDConfiguration.getInstance().getSecret()).addRequestURL(RDConfiguration.getInstance().getOauthEndpoint()).addAccessURL(RDConfiguration.getInstance().getOauthEndpoint()).addParameter("scope", RDConfiguration.getInstance().getScopeUrl()).addParameter("secondSecret", RDConfiguration.getInstance().getSecondSecret());
        return builder;
    }

    public static void clearCache() {
        if (instance != null) {
            instance.collapse();
        }
    }

    @Transient
    public Date getDateForSyncPlus(Date date) {
        return DateTimeUtils.addTime(date, 12, this.getSyncPlusTime());
    }

    @Transient
    public Date getDateForSyncMinus(Date date) {
        return DateTimeUtils.addTime(date, 12, -this.getSyncMinusTime().intValue());
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> KEY;
        public PropertiedObject.Property<String> SECRET;
        public PropertiedObject.Property<String> SECOND_SECRET;
        public PropertiedObject.Property<Integer> RESTAURANT_ID;
        public PropertiedObject.Property<String> WEBSERVICE_URL;
        public PropertiedObject.Property<String> SCOPE_URL;
        public PropertiedObject.Property<String> OAUTH_ENDPOINT;
        public PropertiedObject.Property<Integer> SYNC_FREQUENCY;
        public PropertiedObject.Property<Integer> SYNC_PLUS_TIME;
        public PropertiedObject.Property<Integer> SYNC_MINUS_TIME;
    }
}

