/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.integration.accounting.AccountingIntegrationExportFrequency;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.schedule.Schedule;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_accounting")
@AccessType(value="property")
public class AccountingIntegrationConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private static LocalCachedReference<AccountingIntegrationConfig> instance = new LocalCachedReference<AccountingIntegrationConfig>(new QueryReference<AccountingIntegrationConfig>(AccountingIntegrationConfig.class, Query.select(AccountingIntegrationConfig.class)));
    public static final int LIMITATION_DAYS = 7;
    private FinanceExportStyle type;
    private boolean exportSalesData;
    private boolean exportStockData;
    private AccountingIntegrationExportFrequency exportFrequency = AccountingIntegrationExportFrequency.Manually;
    private Reference<WebserviceIntegrationConfig> webserviceConfig;
    private String salesInvCustomer;
    private Date lastExportDate;
    private String apiVersion;
    private boolean includeDiscountEntries;
    private boolean includeSurchargeEntries;
    private String exportPrefix;
    private boolean groupBySalesLocation;
    private boolean exportReconciliationSeparately;
    private boolean breakdownVariationByType;
    private boolean includeNegativeEntries;
    private boolean includeZeroEntries;
    private boolean excludeTaxCodes;
    private boolean defaultDueDate;
    private int retryDays;

    public AccountingIntegrationConfig() {
        this.webserviceConfig = this.createReference(AccountingIntegrationConfig.Properties.WEBSERVICE_CONFIG);
        this.includeDiscountEntries = true;
        this.includeSurchargeEntries = true;
        this.groupBySalesLocation = false;
        this.includeNegativeEntries = false;
        this.includeZeroEntries = true;
        this.excludeTaxCodes = false;
        this.defaultDueDate = false;
        this.retryDays = 7;
    }

    public static AccountingIntegrationConfig getInstance() {
        AccountingIntegrationConfig config = instance.get();
        if (config == null) {
            config = new AccountingIntegrationConfig();
            config.save();
            instance.collapse();
        }
        return config;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            throw new IllegalStateException("AccountingIntegrationConfig is a Singleton so a new instance must not be created.");
        }
        this.webserviceConfig.saveChild();
        PersistenceManager.save(this);
        this.setupScheduledTask();
        instance.collapse();
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    public FinanceExportStyle getType() {
        return this.type;
    }

    public void setType(FinanceExportStyle type) {
        this.type = type;
    }

    @Column(name="export_sales_data")
    public boolean isExportSalesData() {
        return this.exportSalesData;
    }

    public void setExportSalesData(boolean exportSalesData) {
        this.exportSalesData = exportSalesData;
    }

    @Column(name="export_stock_data")
    public boolean isExportStockData() {
        return this.exportStockData;
    }

    public void setExportStockData(boolean exportStockData) {
        this.exportStockData = exportStockData;
    }

    @Column(name="export_frequency")
    @Enumerated(value=EnumType.STRING)
    public AccountingIntegrationExportFrequency getExportFrequency() {
        return this.exportFrequency;
    }

    public void setExportFrequency(AccountingIntegrationExportFrequency exportFrequency) {
        this.exportFrequency = exportFrequency;
    }

    @ManyToOne
    @JoinColumn(name="fk_webservice_config", referencedColumnName="ID")
    public WebserviceIntegrationConfig getWebserviceConfig() {
        if (this.webserviceConfig.get() == null) {
            this.webserviceConfig.set(new WebserviceIntegrationConfig());
        }
        if (this.webserviceConfig.get().getDescription() == null) {
            this.webserviceConfig.get().setDescription("Accounting Integration");
            this.webserviceConfig.get().save();
        }
        return this.webserviceConfig.get();
    }

    public void setWebserviceConfig(WebserviceIntegrationConfig webserviceConfig) {
        this.webserviceConfig.set(webserviceConfig);
    }

    @Column(name="export_sales_customer")
    public String getSalesInvCustomer() {
        return this.salesInvCustomer;
    }

    public void setSalesInvCustomer(String salesInvCustomer) {
        this.salesInvCustomer = salesInvCustomer;
    }

    @Column(name="last_export_date")
    @Temporal(value=TemporalType.DATE)
    public Date getLastExportDate() {
        return this.lastExportDate;
    }

    public void setLastExportDate(Date lastExportDate) {
        this.lastExportDate = lastExportDate;
    }

    @Transient
    public String getCronScheduleString() {
        Date changeDayTime = SystemProperty.getInstance().getChangeDayTime();
        int hour = changeDayTime.getHours() + 1 > 23 ? 23 : changeDayTime.getHours() + 1;
        int minute = changeDayTime.getMinutes();
        String dayPart = "";
        switch (this.exportFrequency) {
            case Manually: {
                break;
            }
            case Custom: {
                break;
            }
            case Daily: {
                dayPart = " * * ?";
                break;
            }
            case Weekly: {
                dayPart = " ? * 1";
                break;
            }
            case Monthly: {
                dayPart = " 1 * ?";
                break;
            }
            case Annually: {
                dayPart = " 1 7 ?";
            }
        }
        return "0 " + minute + " " + hour + dayPart;
    }

    private void setupScheduledTask() {
        Schedule accSchedule = Schedule.findByLabel("Accounting Integration Export Task");
        if (AccountingIntegrationExportFrequency.Manually.equals((Object)this.exportFrequency)) {
            if (accSchedule != null) {
                accSchedule.delete();
            }
        } else {
            if (AccountingIntegrationExportFrequency.Custom.equals((Object)this.exportFrequency)) {
                return;
            }
            if (accSchedule == null) {
                accSchedule = new Schedule();
                accSchedule.setTask("Accounting Integration Export Task");
                accSchedule.setLabel("Accounting Integration Export Task");
            }
            accSchedule.setRecurrence(this.getCronScheduleString());
            accSchedule.save();
        }
    }

    @Column(name="api_version")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Column(name="include_discount_entries")
    public boolean isIncludeDiscountEntries() {
        return this.includeDiscountEntries;
    }

    public void setIncludeDiscountEntries(boolean includeDiscountEntries) {
        this.includeDiscountEntries = includeDiscountEntries;
    }

    @Column(name="include_surcharge_entries")
    public boolean isIncludeSurchargeEntries() {
        return this.includeSurchargeEntries;
    }

    public void setIncludeSurchargeEntries(boolean includeSurchargeEntries) {
        this.includeSurchargeEntries = includeSurchargeEntries;
    }

    @Column(name="export_prefix")
    public String getExportPrefix() {
        return this.exportPrefix;
    }

    public void setExportPrefix(String exportPrefix) {
        this.exportPrefix = exportPrefix;
    }

    @Column(name="group_by_sales_location")
    public boolean isGroupBySalesLocation() {
        return this.groupBySalesLocation;
    }

    public void setGroupBySalesLocation(boolean groupByTerminalLocation) {
        this.groupBySalesLocation = groupByTerminalLocation;
    }

    @Column(name="export_reconciliation_separately")
    public boolean isExportReconciliationSeparately() {
        return this.exportReconciliationSeparately;
    }

    public void setExportReconciliationSeparately(boolean exportReconciliationSeparately) {
        this.exportReconciliationSeparately = exportReconciliationSeparately;
    }

    @Column(name="breakdown_variance_by_type")
    public boolean isBreakdownVariationByType() {
        return this.breakdownVariationByType;
    }

    public void setBreakdownVariationByType(boolean breakdownVariationByType) {
        this.breakdownVariationByType = breakdownVariationByType;
    }

    @Column(name="include_negative_entries")
    public boolean isIncludeNegativeEntries() {
        return this.includeNegativeEntries;
    }

    public void setIncludeNegativeEntries(boolean includeNegativeEntries) {
        this.includeNegativeEntries = includeNegativeEntries;
    }

    @Column(name="include_zero_entries")
    public boolean isIncludeZeroEntries() {
        return this.includeZeroEntries;
    }

    public void setIncludeZeroEntries(boolean includeZeroEntries) {
        this.includeZeroEntries = includeZeroEntries;
    }

    @Column(name="exclude_tax_codes")
    public boolean isExcludeTaxCodes() {
        return this.excludeTaxCodes;
    }

    public void setExcludeTaxCodes(boolean excludeTaxCodes) {
        this.excludeTaxCodes = excludeTaxCodes;
    }

    @Column(name="default_due_date")
    public boolean isDefaultDueDate() {
        return this.defaultDueDate;
    }

    public void setDefaultDueDate(boolean defaultDueDate) {
        this.defaultDueDate = defaultDueDate;
    }

    private boolean isLastExportDateOutdated(Date lastExportDate) {
        if (lastExportDate != null) {
            Date currentDate = new Date();
            long timeDifference = currentDate.getTime() - lastExportDate.getTime();
            long daysDifference = timeDifference / 86400000L;
            return daysDifference >= 7L;
        }
        return true;
    }

    public boolean updateLastExportDateToCurrent() {
        Date lastExportDate = AccountingIntegrationConfig.getInstance().getLastExportDate();
        if (lastExportDate == null) {
            return false;
        }
        if (this.isLastExportDateOutdated(lastExportDate)) {
            AccountingIntegrationConfig.getInstance().setLastExportDate(new Date());
            PersistenceManager.update(AccountingIntegrationConfig.getInstance(), new PropertiedObject.Property[]{AccountingIntegrationConfig.Properties.LAST_EXPORT_DATE});
            return true;
        }
        return false;
    }

    @Column(name="retry_days")
    public int getRetryDays() {
        return this.retryDays;
    }

    public void setRetryDays(int retryDays) {
        this.retryDays = retryDays;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<FinanceExportStyle> TYPE;
        public PropertiedObject.Property<Boolean> EXPORT_SALES_DATA;
        public PropertiedObject.Property<Boolean> EXPORT_STOCK_DATA;
        public PropertiedObject.Property<AccountingIntegrationExportFrequency> EXPORT_FREQUENCY;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEBSERVICE_CONFIG;
        public PropertiedObject.Property<String> SALES_INV_CUSTOMER;
        public PropertiedObject.Property<Date> LAST_EXPORT_DATE;
        public PropertiedObject.Property<String> API_VERSION;
        public PropertiedObject.Property<Boolean> INCLUDE_DISCOUNT_ENTRIES;
        public PropertiedObject.Property<Boolean> INCLUDE_SURCHARGE_ENTRIES;
        public PropertiedObject.Property<String> EXPORT_PREFIX;
        public PropertiedObject.Property<Boolean> GROUP_BY_SALES_LOCATION;
        public PropertiedObject.Property<Boolean> EXPORT_RECONCILIATION_SEPARATELY;
        public PropertiedObject.Property<Boolean> BREAKDOWN_VARIATION_BY_TYPE;
        public PropertiedObject.Property<Boolean> INCLUDE_NEGATIVE_ENTRIES;
        public PropertiedObject.Property<Boolean> INCLUDE_ZERO_ENTRIES;
        public PropertiedObject.Property<Boolean> EXCLUDE_TAX_CODES;
        public PropertiedObject.Property<Boolean> DEFAULT_DUE_DATE;
        public PropertiedObject.Property<Integer> RETRY_DAYS;
    }
}

