/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.AccountingRetryExportType;
import ordermate.database.misc.TradingDay;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_retry_export_tasks")
@AccessType(value="property")
public class ConfigRetryExportTasks
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private AccountingRetryExportType type;
    private Reference<TradingDay> tradingDay;
    private Date exportDate;
    private Date lastAttempt;
    private int retryCount;
    private String failureReason;
    private boolean retrySuccess;

    public ConfigRetryExportTasks() {
        this.tradingDay = this.createReference(ConfigRetryExportTasks.Properties.TRADING_DAY);
    }

    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    public AccountingRetryExportType getType() {
        return this.type;
    }

    public void setType(AccountingRetryExportType type) {
        this.type = type;
    }

    @Column(name="last_attempt")
    @Temporal(value=TemporalType.DATE)
    public Date getLastAttempt() {
        return this.lastAttempt;
    }

    public void setLastAttempt(Date lastAttempt) {
        this.lastAttempt = lastAttempt;
    }

    @Column(name="retry_count")
    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    @Column(name="failure_reason")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public void setTradingDay(TradingDay newTradingDay) {
        this.tradingDay.set(newTradingDay);
    }

    @Column(name="retry_success")
    public boolean getRetrySuccess() {
        return this.retrySuccess;
    }

    public void setRetrySuccess(boolean b) {
        this.retrySuccess = b;
    }

    public static List<ConfigRetryExportTasks> getFailedRetryExportTasksListWithinRetryDays() {
        int retryDays = AccountingIntegrationConfig.getInstance().getRetryDays();
        List<ConfigRetryExportTasks> failedConfigRetryExportTasks = PersistenceManager.getObjectList(ConfigRetryExportTasks.class, Query.select(ConfigRetryExportTasks.class).equals((PropertiedObject.Property)ConfigRetryExportTasks.Properties.RETRY_SUCCESS, Boolean.FALSE).greaterThanOrEqual(ConfigRetryExportTasks.Properties.EXPORT_DATE, DateTimeUtils.getDaysBefore(retryDays), SQLDateType.DATE).toString());
        return failedConfigRetryExportTasks;
    }

    public static ConfigRetryExportTasks getRetryExportTasksListByTradingDaysAndType(TradingDay tradingDay, AccountingRetryExportType type) {
        ConfigRetryExportTasks retryExportTasks = PersistenceManager.getObject(ConfigRetryExportTasks.class, Query.select(ConfigRetryExportTasks.class).equals(ConfigRetryExportTasks.Properties.TYPE, (Object)type).equals(ConfigRetryExportTasks.Properties.TRADING_DAY, tradingDay).toString());
        return retryExportTasks;
    }

    @Column(name="export_date")
    @Temporal(value=TemporalType.DATE)
    public Date getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(Date exportDate) {
        this.exportDate = exportDate;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<AccountingRetryExportType> TYPE;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Date> EXPORT_DATE;
        public PropertiedObject.Property<Date> LAST_ATTEMPT;
        public PropertiedObject.Property<Integer> RETRY_COUNT;
        public PropertiedObject.Property<Boolean> RETRY_SUCCESS;
        public PropertiedObject.Property<String> FAILURE_REASON;
    }
}

