/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_acc_group_location_link")
@AccessType(value="property")
public class InventoryGroupToLocationAccLink
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<SalesLocation> salesLocation;
    private Reference<GLAccount> glCode;
    private static final String DELETION_QUERY = "DELETE FROM config_integration_acc_group_location_link WHERE (fk_inventory_group NOT IN (SELECT ID FROM inventory_group WHERE system_state = 'ACTIVE')) OR (fk_config_sales_location NOT IN (SELECT ID FROM config_sales_location WHERE system_state = 'ACTIVE'))";
    private static final String MISSING_LOCATIONS_BY_INV_GROUP_QUERY = "SELECT * FROM config_sales_location WHERE SYSTEM_STATE = 'ACTIVE' AND ID NOT IN (SELECT fk_config_sales_location FROM config_integration_acc_group_location_link WHERE fk_inventory_group = ?);";

    public InventoryGroupToLocationAccLink() {
        this.inventoryGroup = this.createReference(InventoryGroupToLocationAccLink.Properties.INVENTORY_GROUP);
        this.salesLocation = this.createReference(InventoryGroupToLocationAccLink.Properties.SALES_LOCATION);
        this.glCode = this.createReference(InventoryGroupToLocationAccLink.Properties.GL_CODE);
    }

    public InventoryGroupToLocationAccLink(InventoryGroup invGroup, SalesLocation termLocation) {
        this.inventoryGroup = this.createReference(InventoryGroupToLocationAccLink.Properties.INVENTORY_GROUP);
        this.salesLocation = this.createReference(InventoryGroupToLocationAccLink.Properties.SALES_LOCATION);
        this.glCode = this.createReference(InventoryGroupToLocationAccLink.Properties.GL_CODE);
        this.setInventoryGroup(invGroup);
        this.setSalesLocation(termLocation);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_group")
    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public void setInventoryGroup(InventoryGroup inventoryGroup) {
        this.inventoryGroup.set(inventoryGroup);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_sales_location")
    public SalesLocation getSalesLocation() {
        return this.salesLocation.get();
    }

    public void setSalesLocation(SalesLocation salesLocation) {
        this.salesLocation.set(salesLocation);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_acc_gl_account")
    public GLAccount getGlCode() {
        return this.glCode.get();
    }

    public void setGlCode(GLAccount glCode) {
        this.glCode.set(glCode);
    }

    public static void deleteAllRedundantLinks() {
        PersistenceManager.getPersistenceDelegate().executeUpdate(DELETION_QUERY, null);
    }

    public static void createAllMissingLinks() {
        List<InventoryGroup> allGroups = InventoryGroupQueries.getAllGroups();
        for (InventoryGroup group : allGroups) {
            List<SalesLocation> allMissingLocation = PersistenceManager.getObjectList(SalesLocation.class, MISSING_LOCATIONS_BY_INV_GROUP_QUERY, new Object[]{group.getID()});
            for (SalesLocation termLoc : allMissingLocation) {
                InventoryGroupToLocationAccLink link = new InventoryGroupToLocationAccLink(group, termLoc);
                link.save();
            }
        }
    }

    @Transient
    public static List<InventoryGroupToLocationAccLink> getAllInventoryGroupToTerminalLocationAccLinks() {
        return PersistenceManager.getObjectList(InventoryGroupToLocationAccLink.class, Query.select(InventoryGroupToLocationAccLink.class).linkUsing(InventoryGroupToLocationAccLink.Properties.INVENTORY_GROUP).linkUsing(InventoryGroupToLocationAccLink.Properties.SALES_LOCATION).orderBy(InventoryGroup.Properties.LABEL).orderBy(SalesLocation.Properties.LABEL).toString());
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<GLAccount> GL_CODE;
    }
}

