/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.formats;

import au.com.ordermate.util.Price;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.formats.ReportFormat;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.settings.GLAccount;

public class DefaultReportFormat
implements ReportFormat {
    @Override
    public String getJournalNumber(AccountingReport report) {
        return AccountingIntegrationConfig.getInstance().getExportPrefix() + report.getRecordID();
    }

    @Override
    public String getGLCode(AccountingReport report) {
        return report.getGlAccountCode();
    }

    @Override
    public String getAccountName(AccountingReport report) {
        GLAccount account = GLAccount.getGLAccountForGLCode(report.getGlAccountCode());
        return account == null ? "" : account.getName();
    }

    @Override
    public boolean isExportZeroNetSales() {
        return true;
    }

    @Override
    public boolean isEmptyLineBetweenSets() {
        return true;
    }

    @Override
    public String getPriceFormat() {
        return "$0.00";
    }

    @Override
    public boolean isGLCodeUsedForAccountId() {
        return true;
    }

    @Override
    public boolean isFreightShownInvoiceReports() {
        return false;
    }

    @Override
    public boolean isAdminChargeShownInvoiceReports() {
        return true;
    }

    @Override
    public boolean isDiscountReportsShownInvoiceReports() {
        return true;
    }

    @Override
    public boolean isExportToFile() {
        return true;
    }

    @Override
    public String getMemo(AccountingReport report) {
        return report.getMemo();
    }

    @Override
    public boolean isOutputReconciliationReports() {
        return true;
    }

    @Override
    public Price getNettAmountInc(Price amount, TaxCode tax) {
        return amount;
    }

    @Override
    public String getExportFileExtension() {
        return ".csv";
    }

    @Override
    public boolean isInvoiceDiscountNegative() {
        return true;
    }
}

