/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.reports;

import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.util.Price;
import ordermate.database.finance.Shift;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.integration.finance.AccountingExportManager;

public class AccountingDebtorReport
implements AccountingReport {
    private static final double DEFAULT_ROUNDING = 0.01;
    private static final Price DEF_ZERO = new Price(0.0, 0.01);
    private Price amountAdded;
    private Price amountPaid;
    private Price amountDiscounted;
    private Price amountSurcharged;
    private Price amountPreviousTxn;
    private FKReference<Shift> financeShift = new FKReference<Shift>(Shift.class);
    private boolean reconciliationEntry = false;

    public AccountingDebtorReport(Long shiftID, Double added, Double paid, Double discounted, Double surcharged, Double previousTxn) {
        this.amountAdded = added == null ? DEF_ZERO : new Price(added, 0.01);
        this.amountPaid = paid == null ? DEF_ZERO : new Price(paid, 0.01);
        this.amountDiscounted = discounted == null ? DEF_ZERO : new Price(discounted, 0.01);
        this.amountSurcharged = surcharged == null ? DEF_ZERO : new Price(surcharged, 0.01);
        this.amountPreviousTxn = previousTxn == null ? DEF_ZERO : new Price(previousTxn, 0.01);
        this.financeShift.setObjectID(shiftID);
    }

    @Override
    public Price getTotal() {
        return this.getAmountAdded().add(this.getAmountSurcharged()).subtract(this.getAmountPaid()).subtract(this.getAmountDiscounted());
    }

    public Long getID() {
        return this.financeShift.getObjectID();
    }

    public boolean isPersistent() {
        return false;
    }

    public Price getAmountAdded() {
        return this.amountAdded;
    }

    public boolean hasAmountAdded() {
        return this.hasPrice(this.amountAdded);
    }

    public Price getAmountPaid() {
        return this.amountPaid;
    }

    public boolean hasAmountPaid() {
        return this.hasPrice(this.amountPaid);
    }

    public Price getAmountDiscounted() {
        return this.amountDiscounted;
    }

    public boolean hasAmountDiscounted() {
        return this.hasPrice(this.amountDiscounted);
    }

    public Price getAmountSurcharged() {
        return this.amountSurcharged;
    }

    public boolean hasAmountSurcharged() {
        return this.hasPrice(this.amountSurcharged);
    }

    public Price getAmountPreviousTxn() {
        return this.amountPreviousTxn;
    }

    public boolean hasAmountPreviousTxn() {
        return this.hasPrice(this.amountPreviousTxn);
    }

    private boolean hasPrice(Price toCheck) {
        return toCheck != null && !toCheck.equals(DEF_ZERO);
    }

    @Override
    public Shift getShift() {
        return (Shift)this.financeShift.get();
    }

    @Override
    public String getAllocationMemo() {
        return "";
    }

    @Override
    public String getMemo() {
        return "";
    }

    @Override
    public TaxCode getTaxCode() {
        return TaxCode.getNotTaxable();
    }

    @Override
    public GLAccount getGlAccount() {
        return AccountingExportManager.getInstance().getAccountingSettings().getDefaultDebtorGLCode();
    }

    @Override
    public GLAccount getGlAccountOrDefault() {
        return AccountingExportManager.getInstance().getAccountingSettings().getDefaultDebtorGLCode();
    }

    @Override
    public String getGlAccountCode() {
        if (AccountingExportManager.getInstance().getAccountingSettings().getDefaultDebtorGLCode() != null) {
            return AccountingExportManager.getInstance().getAccountingSettings().getDefaultDebtorGLCode().getGlCode();
        }
        return "";
    }

    public Class<? extends AccountingDebtorReport> getObjectType() {
        return this.getClass();
    }

    @Override
    public long getRecordID() {
        return this.financeShift.getID();
    }

    @Override
    public void setAllocationMemoPrefix(String prefix) {
    }

    @Override
    public void addReport(AccountingReport reportToAdd) {
        if (reportToAdd instanceof AccountingDebtorReport) {
            this.amountAdded = this.getSafeNonNullPrice(this.amountAdded).add(this.getSafeNonNullPrice(((AccountingDebtorReport)reportToAdd).amountAdded));
            this.amountPaid = this.getSafeNonNullPrice(this.amountPaid).add(this.getSafeNonNullPrice(((AccountingDebtorReport)reportToAdd).amountPaid));
            this.amountDiscounted = this.getSafeNonNullPrice(this.amountDiscounted).add(this.getSafeNonNullPrice(((AccountingDebtorReport)reportToAdd).amountDiscounted));
            this.amountSurcharged = this.getSafeNonNullPrice(this.amountSurcharged).add(this.getSafeNonNullPrice(((AccountingDebtorReport)reportToAdd).amountSurcharged));
            this.amountPreviousTxn = this.getSafeNonNullPrice(this.amountPreviousTxn).add(this.getSafeNonNullPrice(((AccountingDebtorReport)reportToAdd).amountPreviousTxn));
        }
    }

    @Override
    public String getAllocationMemoPrefix() {
        return "";
    }

    private Price getSafeNonNullPrice(Price price) {
        if (price != null) {
            return price;
        }
        return Price.ZERO_DOLLAR;
    }

    @Override
    public boolean isReconciliationEntry() {
        return this.reconciliationEntry;
    }

    @Override
    public void setReconciliationEntry(boolean reconciliation) {
        this.reconciliationEntry = reconciliation;
    }
}

