/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.reports;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ordermate.database.finance.Shift;
import ordermate.database.integration.accounting.reports.AccountingDebtorReport;
import org.apache.commons.lang.NotImplementedException;

public class AccountingDebtorReportHashMap
extends AbstractMap<Long, AccountingDebtorReport> {
    private Map<Long, Double> debtorSales = new HashMap<Long, Double>();
    private Map<Long, Double> debtorPayments = new HashMap<Long, Double>();
    private Map<Long, Double> debtorDiscounts = new HashMap<Long, Double>();
    private Map<Long, Double> debtorSurcharges = new HashMap<Long, Double>();
    private Map<Long, Double> appliedPrevTxn = new HashMap<Long, Double>();
    protected static final String selectTotalDebtorSalesForShiftRange = "SELECT fk_finance_shift, SUM(total) from debtor_sale WHERE fk_finance_shift between ? AND ? GROUP BY fk_finance_shift";
    protected static final String selectTotalDebtorPaymentsForShiftRange = "SELECT finance_transaction.fk_finance_shift, SUM(amount) FROM debtor_payment INNER JOIN finance_transaction ON debtor_payment.fk_finance_transaction = finance_transaction.ID INNER JOIN finance_unit ON finance_transaction.fk_finance_unit = finance_unit.ID WHERE finance_transaction.system_state = 'ACTIVE' AND finance_transaction.fk_finance_shift between ? AND ?  AND finance_unit.unit_type != 'ACCOUNT' GROUP BY finance_transaction.fk_finance_shift";
    protected static final String selectTotalDebtorDiscountsForShiftRange = "SELECT finance_transaction.fk_finance_shift, \tsum(IF(amount_paid > 0, amount, 0)) as discounted FROM finance_transaction INNER JOIN finance_unit ON fk_finance_unit = finance_unit.ID INNER JOIN debtor_payment on debtor_payment.FK_finance_transaction = finance_transaction.ID WHERE finance_transaction.system_state = 'ACTIVE' AND finance_transaction.fk_finance_shift between ? and ? AND finance_unit.unit_type=  'ACCOUNT' GROUP BY finance_transaction.fk_finance_shift";
    protected static final String selectTotalDebtorSurchargesForShiftRange = "SELECT finance_transaction.fk_finance_shift, \tsum(IF(amount_paid < 0, debtor_payment.amount * -1, 0)) as surcharged FROM finance_transaction INNER JOIN finance_unit ON fk_finance_unit = finance_unit.ID INNER JOIN debtor_payment on debtor_payment.FK_finance_transaction = finance_transaction.ID WHERE finance_transaction.system_state = 'ACTIVE' AND finance_transaction.fk_finance_shift between ? and ? AND finance_unit.unit_type=  'ACCOUNT' GROUP BY finance_transaction.fk_finance_shift";
    protected static final String selectTotalDebtorAppPrevTxnForShiftRange = "SELECT finance_transaction.fk_finance_shift, SUM(finance_transaction.amount_paid) as appPrevTxn FROM finance_transaction WHERE finance_transaction.fk_finance_shift between ? AND ? AND finance_transaction.FK_finance_transaction IS NOT null AND finance_transaction.system_state = 'ACTIVE' GROUP BY finance_transaction.fk_finance_shift";

    public AccountingDebtorReportHashMap(Shift startShift, Shift endShift) {
        this.debtorSales = this.getNewHashMap(startShift, endShift);
        this.debtorPayments = this.getNewHashMap(startShift, endShift);
        this.debtorDiscounts = this.getNewHashMap(startShift, endShift);
        this.debtorSurcharges = this.getNewHashMap(startShift, endShift);
        this.appliedPrevTxn = this.getNewHashMap(startShift, endShift);
        this.insertIntoMap(this.debtorSales, PersistenceManager.getPersistenceDelegate().executeQuery(selectTotalDebtorSalesForShiftRange, new Object[]{startShift.getID(), endShift.getID()}));
        this.insertIntoMap(this.debtorPayments, PersistenceManager.getPersistenceDelegate().executeQuery(selectTotalDebtorPaymentsForShiftRange, new Object[]{startShift.getID(), endShift.getID()}));
        this.insertIntoMap(this.debtorDiscounts, PersistenceManager.getPersistenceDelegate().executeQuery(selectTotalDebtorDiscountsForShiftRange, new Object[]{startShift.getID(), endShift.getID()}));
        this.insertIntoMap(this.debtorSurcharges, PersistenceManager.getPersistenceDelegate().executeQuery(selectTotalDebtorSurchargesForShiftRange, new Object[]{startShift.getID(), endShift.getID()}));
        this.insertIntoMap(this.appliedPrevTxn, PersistenceManager.getPersistenceDelegate().executeQuery(selectTotalDebtorAppPrevTxnForShiftRange, new Object[]{startShift.getID(), endShift.getID()}));
    }

    @Override
    public Set<Long> keySet() {
        HashSet<Long> keySet = new HashSet<Long>(this.debtorSales.size());
        keySet.addAll(this.debtorSales.keySet());
        keySet.addAll(this.debtorPayments.keySet());
        keySet.addAll(this.debtorDiscounts.keySet());
        keySet.addAll(this.debtorSurcharges.keySet());
        keySet.addAll(this.appliedPrevTxn.keySet());
        return keySet;
    }

    @Override
    public AccountingDebtorReport get(Object key) {
        if (key == null) {
            return null;
        }
        Long keyLong = Long.valueOf(key.toString());
        return this.get(keyLong);
    }

    public AccountingDebtorReport get(Long ShiftID) {
        return new AccountingDebtorReport(ShiftID, this.debtorSales.get(ShiftID), this.debtorPayments.get(ShiftID), this.debtorDiscounts.get(ShiftID), this.debtorSurcharges.get(ShiftID), this.appliedPrevTxn.get(ShiftID));
    }

    private void insertIntoMap(Map map, Object[][] resultSet) {
        for (int i = 0; i < resultSet.length; ++i) {
            map.put(resultSet[i][0], resultSet[i][1]);
        }
    }

    private HashMap<Long, Double> getNewHashMap(Shift start, Shift end) {
        return new HashMap<Long, Double>();
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Set<Map.Entry<Long, AccountingDebtorReport>> entrySet() {
        throw new NotImplementedException();
    }
}

