/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.GLAccountCode;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.misc.TradingDay;
import ordermate.integration.finance.AccountingExportManager;

public class AccountingFinanceReport
extends PersistentObject
implements AccountingReport,
Cloneable {
    public static final Props Properties = new Props();
    private Date date;
    private Price amount;
    private Price amountEx;
    private String paymentMethod;
    private String unitType;
    private String cashDrawerName;
    private Reference<FinanceUnit> financeUnit;
    private Reference<CashDrawer> cashDrawer;
    private Reference<Shift> shift;
    private Reference<TradingDay> tradingDay;
    private Reference<FinanceTransaction> sourceFinanceTransaction;
    private Reference<FinanceTransaction> financeTransaction;
    private Reference<GLAccount> glAccount;
    private Reference<SalesLocation> salesLocation;
    private TaxCode taxCode;
    private String allocationMemoPrefix;
    private static final double reportRounding = 0.01;
    private boolean showPaymentAndCashdrawer;
    private boolean reconciliationEntry;

    public AccountingFinanceReport() {
        this.financeUnit = this.createReference(AccountingFinanceReport.Properties.FINANCE_UNIT);
        this.cashDrawer = this.createReference(AccountingFinanceReport.Properties.CASH_DRAWER);
        this.shift = this.createReference(AccountingFinanceReport.Properties.SHIFT);
        this.tradingDay = this.createReference(AccountingFinanceReport.Properties.TRADING_DAY);
        this.sourceFinanceTransaction = this.createReference(AccountingFinanceReport.Properties.SOURCE_FINANCE_TRANSACTION);
        this.financeTransaction = this.createReference(AccountingFinanceReport.Properties.FINANCE_TRANSACTION);
        this.glAccount = this.createReference(AccountingFinanceReport.Properties.GL_ACCOUNT);
        this.salesLocation = this.createReference(AccountingFinanceReport.Properties.SALES_LOCATION);
        this.taxCode = TaxCode.getNotTaxable();
        this.allocationMemoPrefix = "payment: ";
        this.showPaymentAndCashdrawer = true;
        this.reconciliationEntry = false;
    }

    public AccountingFinanceReport(AccountingFinanceReport toCopy) {
        this.financeUnit = this.createReference(AccountingFinanceReport.Properties.FINANCE_UNIT);
        this.cashDrawer = this.createReference(AccountingFinanceReport.Properties.CASH_DRAWER);
        this.shift = this.createReference(AccountingFinanceReport.Properties.SHIFT);
        this.tradingDay = this.createReference(AccountingFinanceReport.Properties.TRADING_DAY);
        this.sourceFinanceTransaction = this.createReference(AccountingFinanceReport.Properties.SOURCE_FINANCE_TRANSACTION);
        this.financeTransaction = this.createReference(AccountingFinanceReport.Properties.FINANCE_TRANSACTION);
        this.glAccount = this.createReference(AccountingFinanceReport.Properties.GL_ACCOUNT);
        this.salesLocation = this.createReference(AccountingFinanceReport.Properties.SALES_LOCATION);
        this.taxCode = TaxCode.getNotTaxable();
        this.allocationMemoPrefix = "payment: ";
        this.showPaymentAndCashdrawer = true;
        this.reconciliationEntry = false;
        this.date = toCopy.date;
        this.amount = toCopy.amount;
        this.amountEx = toCopy.amountEx;
        this.paymentMethod = toCopy.paymentMethod;
        this.unitType = toCopy.unitType;
        this.cashDrawerName = toCopy.cashDrawerName;
        this.financeUnit.set(toCopy.getFinanceUnit());
        this.cashDrawer.set(toCopy.getCashDrawer());
        this.shift.set(toCopy.getShift());
        this.tradingDay.set(toCopy.getTradingDay());
        this.financeTransaction.set(toCopy.getFinanceTransaction());
        this.sourceFinanceTransaction.set(toCopy.getSourceFinanceTransaction());
        this.glAccount.set(toCopy.getGlAccount());
        this.salesLocation.set(toCopy.getSalesLocation());
    }

    public void setAmount(Price newAmount) {
        this.amount = new Price(newAmount, 0.01);
    }

    public void setAmountEx(Price newAmountEx) {
        this.amountEx = new Price(newAmountEx, 0.01);
    }

    @Override
    public void setAllocationMemoPrefix(String prefix) {
        this.allocationMemoPrefix = prefix;
    }

    public void setPaymentMethod(String newPaymentMethod) {
        this.paymentMethod = newPaymentMethod;
    }

    public AccountingFinanceReport getCopy() {
        return new AccountingFinanceReport(this);
    }

    public Date getDate() {
        return this.date;
    }

    public Price getAmount() {
        if (AccountingExportManager.getInstance().getAccountingIntegrationExporter().supportsNegativeEntries() || AccountingIntegrationConfig.getInstance().isIncludeNegativeEntries()) {
            if (this.amount == null) {
                return null;
            }
            return new Price(this.amount, 0.01);
        }
        if (this.amount == null || this.amount.lessThan(Price.ZERO_DOLLAR)) {
            return null;
        }
        return new Price(this.amount, 0.01);
    }

    public Price getAmountEx() {
        if (AccountingExportManager.getInstance().getAccountingIntegrationExporter().supportsNegativeEntries() || AccountingIntegrationConfig.getInstance().isIncludeNegativeEntries()) {
            if (this.amountEx == null) {
                return null;
            }
            return new Price(this.amountEx, 0.01);
        }
        if (this.amountEx == null || this.amount.lessThan(Price.ZERO_DOLLAR)) {
            return null;
        }
        return new Price(this.amountEx, 0.01);
    }

    public Price getAmountNeg() {
        if (this.amount != null && this.amount.lessThan(Price.ZERO_DOLLAR)) {
            return new Price(this.amount, 0.01).negate();
        }
        return null;
    }

    public Price getAmountNegEx() {
        if (this.amountEx != null && this.amountEx.lessThan(Price.ZERO_DOLLAR)) {
            return new Price(this.amountEx, 0.01).negate();
        }
        return null;
    }

    public Price getTaxAmount() {
        Price inc = this.getAmount();
        Price ex = this.getAmountEx();
        if (inc == null) {
            inc = this.getAmountNeg();
            ex = this.getAmountNegEx();
            return inc == null || inc.equals(ex) ? Price.ZERO_DOLLAR : inc.subtract(ex);
        }
        if (inc.equals(ex)) {
            return Price.ZERO_DOLLAR;
        }
        return inc.subtract(ex).negate();
    }

    @Override
    public Price getTotal() {
        return this.amount;
    }

    public void setGLAccount(GLAccount newGLCode) {
        this.glAccount.set(newGLCode);
    }

    @Override
    public GLAccount getGlAccount() {
        return this.glAccount.get();
    }

    @Override
    public GLAccount getGlAccountOrDefault() {
        return this.getGlAccount() != null ? this.getGlAccount() : AccountingExportManager.getInstance().getAccountingSettings().getDefaultFinanceGLCode();
    }

    @Override
    public String getGlAccountCode() {
        if (this.glAccount != null && this.glAccount.get() != null && GLAccountCode.GLValidator.isValidGLCode(this.glAccount.get().getGlCode())) {
            return this.glAccount.get().getGlCode();
        }
        return AccountingExportManager.getInstance().getAccountingSettings().getDefaultFinanceGLCode().getGlCode();
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public String getCashDrawerName() {
        return this.cashDrawerName;
    }

    public FinanceUnit getFinanceUnit() {
        return this.financeUnit.get();
    }

    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    @Override
    public Shift getShift() {
        return this.shift.get();
    }

    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    @Override
    public String getAllocationMemo() {
        if (!this.showPaymentAndCashdrawer) {
            return this.allocationMemoPrefix;
        }
        return this.allocationMemoPrefix + this.getPaymentMethod() + " in Cash drawer:" + this.getCashDrawerName();
    }

    @Override
    public String getMemo() {
        return "Sales for finance shift :" + this.getRecordID();
    }

    @Override
    public TaxCode getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(TaxCode newTaxCode) {
        this.taxCode = newTaxCode;
    }

    public static final AccountingFinanceReport generateBlankReport(Shift newShift) {
        Price ZERO;
        AccountingFinanceReport report = new AccountingFinanceReport();
        report.shift.set(newShift);
        report.amount = ZERO = new Price(0.0, 0.01);
        report.amountEx = ZERO;
        report.taxCode = TaxCode.getNotTaxable();
        report.date = newShift.getTradingDay().getDate();
        report.tradingDay.set(newShift.getTradingDay());
        return report;
    }

    @Override
    public long getRecordID() {
        return this.shift.getID();
    }

    public void setShowPaymentAndCashdrawer(boolean showPaymentAndCashdrawer) {
        this.showPaymentAndCashdrawer = showPaymentAndCashdrawer;
    }

    @Override
    public void addReport(AccountingReport reportToAdd) {
        if (reportToAdd instanceof AccountingFinanceReport) {
            this.amount = this.getSafeNonNullPrice(this.amount).add(this.getSafeNonNullPrice(((AccountingFinanceReport)reportToAdd).amount));
            this.amountEx = this.getSafeNonNullPrice(this.amountEx).add(this.getSafeNonNullPrice(((AccountingFinanceReport)reportToAdd).amountEx));
        } else if (reportToAdd instanceof AccountingSalesReport) {
            this.amount = this.getSafeNonNullPrice(this.amount).add(this.getSafeNonNullPrice(((AccountingSalesReport)reportToAdd).getNettSales()).negate());
            this.amountEx = this.getSafeNonNullPrice(this.amountEx).add(this.getSafeNonNullPrice(((AccountingSalesReport)reportToAdd).getNettSalesEx()).negate());
        }
    }

    @Override
    public String getAllocationMemoPrefix() {
        return this.allocationMemoPrefix != null ? this.allocationMemoPrefix : "";
    }

    private Price getSafeNonNullPrice(Price price) {
        if (price != null) {
            return price;
        }
        return Price.ZERO_DOLLAR;
    }

    @Override
    public boolean isReconciliationEntry() {
        return this.reconciliationEntry;
    }

    @Override
    public void setReconciliationEntry(boolean reconciliation) {
        this.reconciliationEntry = reconciliation;
    }

    public String getLocationName() {
        if (this.getSalesLocation() != null) {
            return this.getSalesLocation().getLabelNoFormat();
        }
        return "";
    }

    public SalesLocation getSalesLocation() {
        return this.salesLocation.get();
    }

    public void setSalesLocation(SalesLocation location) {
        this.salesLocation.set(location);
    }

    public FinanceTransaction getSourceFinanceTransaction() {
        return this.sourceFinanceTransaction.get();
    }

    public void setSourceFinanceTransaction(FinanceTransaction sourceFinanceTransaction) {
        this.sourceFinanceTransaction.set(sourceFinanceTransaction);
    }

    public FinanceTransaction getFinanceTransaction() {
        return this.financeTransaction.get();
    }

    public void setFinanceTransaction(FinanceTransaction financeTransaction) {
        this.financeTransaction.set(financeTransaction);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DATE;
        public PropertiedObject.Property AMOUNT;
        public PropertiedObject.Property AMOUNT_EX;
        public PropertiedObject.Property<GLAccount> GL_ACCOUNT;
        public PropertiedObject.Property PAYMENT_METHOD;
        public PropertiedObject.Property UNIT_TYPE;
        public PropertiedObject.Property CASH_DRAWER_NAME;
        public PropertiedObject.Property<FinanceUnit> FINANCE_UNIT;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<FinanceTransaction> FINANCE_TRANSACTION;
        public PropertiedObject.Property<FinanceTransaction> SOURCE_FINANCE_TRANSACTION;
        public PersistentObject.DerivedProperty<String> LOCATION_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountingFinanceReport.class), "locationName");
        public PersistentObject.DerivedProperty<Price> AMOUNT_NEG = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountingFinanceReport.class), "amountNeg");
        public PersistentObject.DerivedProperty<Price> AMOUNT_NEG_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountingFinanceReport.class), "amountNegEx");
        public PersistentObject.DerivedProperty<Price> TAX_AMOUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountingFinanceReport.class), "taxAmount");
    }
}

