/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.AccountingIntegrationConfig;
import ordermate.database.integration.accounting.GLAccountCode;
import ordermate.database.integration.accounting.reports.AccountingFinanceReport;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.integration.finance.AccountingExportManager;

public class AccountingSalesReport
extends PersistentObject
implements AccountingReport,
Cloneable {
    public static final Props Properties = new Props();
    private static final double reportRounding = 0.01;
    private Price discount;
    private Price surcharge;
    private Price nettSales;
    private Price grossSales;
    private Price taxAmount = Price.ZERO_DOLLAR;
    private String groupName = "";
    private Date date;
    private String locationName = "";
    private String memo = "Sales for trading day";
    private String allocationMemoPrefix = "Sales:";
    private Price accountDiscount;
    private Price accountSurcharge;
    private Reference<TaxCode> taxCode;
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<SalesLocation> salesLocation;
    private Reference<Shift> shift;
    private Reference<TradingDay> tradingDay;
    private Reference<GLAccount> glAccount;
    private boolean reconciliationEntry;

    public static final AccountingSalesReport generateBlankReport(Shift shift) {
        Price ZERO;
        AccountingSalesReport report = new AccountingSalesReport();
        report.shift.set(shift);
        report.nettSales = ZERO = new Price(0.0, 0.01);
        report.grossSales = ZERO;
        report.discount = ZERO;
        report.setID(shift.getID());
        report.surcharge = ZERO;
        report.taxCode.set(TaxCode.getNotTaxable());
        report.date = shift.getTradingDay().getDate();
        report.tradingDay.set(shift.getTradingDay());
        return report;
    }

    public AccountingSalesReport() {
        this.taxCode = this.createReference(AccountingSalesReport.Properties.TAX_CODE);
        this.inventoryGroup = this.createReference(AccountingSalesReport.Properties.INVENTORY_GROUP);
        this.salesLocation = this.createReference(AccountingSalesReport.Properties.SALES_LOCATION);
        this.shift = this.createReference(AccountingSalesReport.Properties.SHIFT);
        this.tradingDay = this.createReference(AccountingSalesReport.Properties.TRADING_DAY);
        this.glAccount = this.createReference(AccountingSalesReport.Properties.GL_ACCOUNT);
        this.reconciliationEntry = false;
    }

    public AccountingSalesReport(AccountingSalesReport toCopy) {
        this.taxCode = this.createReference(AccountingSalesReport.Properties.TAX_CODE);
        this.inventoryGroup = this.createReference(AccountingSalesReport.Properties.INVENTORY_GROUP);
        this.salesLocation = this.createReference(AccountingSalesReport.Properties.SALES_LOCATION);
        this.shift = this.createReference(AccountingSalesReport.Properties.SHIFT);
        this.tradingDay = this.createReference(AccountingSalesReport.Properties.TRADING_DAY);
        this.glAccount = this.createReference(AccountingSalesReport.Properties.GL_ACCOUNT);
        this.reconciliationEntry = false;
        this.date = toCopy.date;
        this.discount = toCopy.discount;
        this.surcharge = toCopy.surcharge;
        this.nettSales = toCopy.nettSales;
        this.grossSales = toCopy.grossSales;
        this.taxCode.set(toCopy.taxCode.get());
        this.groupName = toCopy.groupName;
        this.date = toCopy.date;
        this.locationName = toCopy.locationName;
        this.memo = toCopy.memo;
        this.allocationMemoPrefix = toCopy.allocationMemoPrefix;
        this.accountDiscount = toCopy.accountDiscount;
        this.accountSurcharge = toCopy.accountSurcharge;
        this.taxAmount = toCopy.getTaxAmount();
        this.inventoryGroup.set(toCopy.getInventoryGroup());
        this.salesLocation.set(toCopy.getSalesLocation());
        this.shift.set(toCopy.getShift());
        this.tradingDay.set(toCopy.getTradingDay());
        this.glAccount.set(toCopy.getGlAccount());
    }

    public AccountingSalesReport getCopy() {
        return new AccountingSalesReport(this);
    }

    @Override
    public String getAllocationMemo() {
        StringBuilder sb = new StringBuilder();
        if (this.getGlAccountOrDefault() != null && this.getGlAccountOrDefault().isGrouped()) {
            sb.append(this.getGlAccountOrDefault().getName());
        } else {
            sb.append(this.allocationMemoPrefix);
            if (this.getGroupName() != null && !this.getGroupName().isEmpty()) {
                sb.append(" ").append(this.getGroupName());
            }
            if (this.getLocationName() != null && !this.getLocationName().isEmpty()) {
                sb.append(". Location: ").append(this.getLocationName());
            }
            if (this.taxCode.get().equals(TaxCode.getFreeCode())) {
                sb.append(" " + SystemProperty.getInstance().getBaseTaxLabel() + " free");
            }
        }
        return sb.toString();
    }

    @Override
    public void setAllocationMemoPrefix(String prefix) {
        this.allocationMemoPrefix = prefix;
    }

    public void setNettSales(Price newPrice) {
        this.nettSales = new Price(newPrice, 0.01);
    }

    public void setTaxCode(TaxCode code) {
        this.taxCode.set(code);
    }

    public void setMemo(String newMemo) {
        this.memo = newMemo;
    }

    public void setGroupName(String newName) {
        this.groupName = newName;
    }

    public void removeDiscountsAndSurcharges() {
        this.grossSales = this.nettSales;
        this.discount = new Price(0.0, 0.01);
        this.surcharge = new Price(0.0, 0.01);
    }

    @Override
    public String getMemo() {
        String theMemo = this.memo + this.getTradingDay().getID();
        return theMemo;
    }

    public Price getDiscount() {
        return this.discount;
    }

    public boolean hasDiscount() {
        return this.discount != null && !this.discount.equals(Price.ZERO_DOLLAR);
    }

    public void setDiscount(Price newDiscount) {
        this.discount = new Price(newDiscount, 0.01);
    }

    public Price getSurcharge() {
        return this.surcharge;
    }

    public boolean hasSurcharge() {
        return this.surcharge != null && !this.surcharge.equals(Price.ZERO_DOLLAR);
    }

    public void setSurcharge(Price newSurcharge) {
        this.surcharge = new Price(newSurcharge, 0.01);
    }

    protected void addAccountDiscount(double amount) {
        this.accountDiscount = this.accountDiscount == null ? new Price(amount, 0.01) : this.accountDiscount.add(new Price(amount, 0.01));
    }

    protected void addAccountSurcharge(double amount) {
        this.accountSurcharge = this.accountSurcharge == null ? new Price(amount, 0.01) : this.accountSurcharge.add(new Price(amount, 0.01));
    }

    public Price getAccountDiscount() {
        return this.accountDiscount == null ? new Price(0.0, 0.01) : this.accountDiscount;
    }

    public Price getAccountSurcharge() {
        return this.accountSurcharge == null ? new Price(0.0, 0.01) : this.accountSurcharge;
    }

    public Price getNettSales() {
        if (AccountingExportManager.getInstance().getAccountingIntegrationExporter().supportsNegativeEntries() || AccountingIntegrationConfig.getInstance().isIncludeNegativeEntries()) {
            if (this.nettSales == null) {
                return null;
            }
            return new Price(this.nettSales, 0.01);
        }
        if (this.nettSales == null || this.nettSales.lessThan(Price.ZERO_DOLLAR)) {
            return null;
        }
        return new Price(this.nettSales, 0.01);
    }

    public Price getNettSalesEx() {
        Price salesAmount = this.getNettSales();
        if (salesAmount != null) {
            salesAmount = salesAmount.subtract(this.taxAmount);
            return salesAmount;
        }
        return null;
    }

    public Price getNettSalesNeg() {
        if (this.nettSales != null && this.nettSales.lessThan(Price.ZERO_DOLLAR)) {
            return new Price(this.nettSales, 0.01).negate();
        }
        return null;
    }

    public Price getNettSalesNegEx() {
        Price nettSalesNeg = this.getNettSalesNeg();
        if (nettSalesNeg != null) {
            if (!this.taxAmount.approximatelyEquals(Price.ZERO_DOLLAR)) {
                nettSalesNeg = nettSalesNeg.subtract(this.taxAmount);
            }
            return nettSalesNeg;
        }
        return null;
    }

    public Price getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Price value) {
        this.taxAmount = value;
    }

    @Override
    public Price getTotal() {
        return this.nettSales;
    }

    public Price getGrossSales() {
        return this.grossSales == null ? new Price(0.0, 0.01) : this.grossSales;
    }

    public void setGrossSales(Price value) {
        this.grossSales = value;
    }

    @Override
    public TaxCode getTaxCode() {
        if (this.taxCode == null || this.taxCode.get() == null) {
            return TaxCode.getNotTaxable();
        }
        return this.taxCode.get();
    }

    public Price getGrossSalesExTax() {
        Price salesAmount = this.getGrossSales();
        if (!this.taxAmount.isZero()) {
            salesAmount = salesAmount.subtract(this.taxAmount);
        }
        return salesAmount;
    }

    @Override
    public GLAccount getGlAccount() {
        return this.glAccount.get();
    }

    @Override
    public GLAccount getGlAccountOrDefault() {
        if (this.getGlAccount() != null || this.getInventoryGroup() != null) {
            return this.getGlAccount() != null ? this.getGlAccount() : this.getInventoryGroup().getGlAccountOrDefault();
        }
        return AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesIncomeGLCode();
    }

    @Override
    public String getGlAccountCode() {
        if (this.glAccount != null && this.glAccount.get() != null && GLAccountCode.GLValidator.isValidGLCode(this.glAccount.get().getGlCode())) {
            return this.glAccount.get().getGlCode();
        }
        if (this.getInventoryGroup() != null) {
            return this.getInventoryGroup().getGlAccountCode();
        }
        return AccountingExportManager.getInstance().getAccountingSettings().getDefaultSalesIncomeGLCode().getGlCode();
    }

    public void setGLAccount(GLAccount newGLCode) {
        this.glAccount.set(newGLCode);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Date getDate() {
        return this.date;
    }

    public String getLocationName() {
        return this.locationName;
    }

    @Override
    public Shift getShift() {
        return this.shift.get();
    }

    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public SalesLocation getSalesLocation() {
        return this.salesLocation.get();
    }

    public void setSalesLocation(SalesLocation location) {
        this.salesLocation.set(location);
    }

    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    @Override
    public long getRecordID() {
        return this.shift.getID();
    }

    private Price addPriceSafe(Price amount1, Price amount2) {
        if (amount1 == null) {
            return amount2;
        }
        return amount1.add(amount2);
    }

    @Override
    public void addReport(AccountingReport reportToAdd) {
        if (reportToAdd instanceof AccountingSalesReport) {
            AccountingSalesReport salesReport = (AccountingSalesReport)reportToAdd;
            this.discount = this.addPriceSafe(this.discount, salesReport.getDiscount());
            this.surcharge = this.addPriceSafe(this.surcharge, salesReport.getSurcharge());
            this.nettSales = this.addPriceSafe(this.nettSales, salesReport.getNettSales());
            this.taxAmount = this.addPriceSafe(this.taxAmount, salesReport.getTaxAmount());
            if (!salesReport.getAccountDiscount().isZero()) {
                this.accountDiscount = this.getAccountDiscount().add(salesReport.getAccountDiscount());
            }
            if (!salesReport.getAccountSurcharge().isZero()) {
                this.accountSurcharge = this.getAccountSurcharge().add(salesReport.getAccountSurcharge());
            }
        } else if (reportToAdd instanceof AccountingFinanceReport) {
            AccountingFinanceReport financeReport = (AccountingFinanceReport)reportToAdd;
            this.nettSales = this.nettSales.add(financeReport.getAmount() != null ? financeReport.getAmount().negate() : financeReport.getAmountNeg().negate());
        }
    }

    @Override
    public String getAllocationMemoPrefix() {
        return this.allocationMemoPrefix != null ? this.allocationMemoPrefix : "";
    }

    @Override
    public boolean isReconciliationEntry() {
        return this.reconciliationEntry;
    }

    @Override
    public void setReconciliationEntry(boolean reconciliation) {
        this.reconciliationEntry = reconciliation;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DATE;
        public PropertiedObject.Property DISCOUNT;
        public PropertiedObject.Property SURCHARGE;
        public PropertiedObject.Property NETT_SALES;
        public PropertiedObject.Property GROUP_NAME;
        public PropertiedObject.Property GROSS_SALES;
        public PropertiedObject.Property<GLAccount> GL_ACCOUNT;
        public PropertiedObject.Property LOCATION_NAME;
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<TaxCode> TAX_CODE;
        public PropertiedObject.Property<Price> TAX_AMOUNT;
        public PersistentObject.DerivedProperty<Price> NETT_SALES_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountingSalesReport.class), "nettSalesEx");
        public PersistentObject.DerivedProperty<Price> NETT_SALES_NEG = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountingSalesReport.class), "nettSalesNeg");
        public PersistentObject.DerivedProperty<Price> NETT_SALES_NEG_EX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AccountingSalesReport.class), "nettSalesNegEx");
    }
}

