/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.finance.Shift;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.accounting.reports.AccountingSalesReport;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;

public class AccountingTipsReportMaker {
    public Map<Long, List<AccountingSalesReport>> makeTipsReports(Shift from, Shift to) {
        HashMap<Long, List<AccountingSalesReport>> reportMap = new HashMap<Long, List<AccountingSalesReport>>();
        List<Shift> shifts = PersistenceManager.getObjectList(Shift.class, new ObjectQuery().select(Shift.class).wherePropertyBetween(Shift.Properties.ID, from.getID(), to.getID()).orderBy(Shift.Properties.ID).toString(), null);
        for (Shift shift : shifts) {
            List<AccountingSalesReport> report = this.generateReport(shift);
            if (report == null) continue;
            reportMap.put(shift.getID(), report);
        }
        return reportMap;
    }

    private List<AccountingSalesReport> generateReport(Shift shift) {
        String memo = "Tips";
        ObjectQuery query = Query.sum(FinanceTransaction.Properties.TIP, "price").select(FinanceTransaction.Properties.SUB_TYPE).select(FinanceTransaction.Properties.ID).equals(FinanceTransaction.Properties.SYSTEM_STATE, "ACTIVE").equals(FinanceTransaction.Properties.SHIFT, shift).groupBy(FinanceTransaction.Properties.SUB_TYPE).orderBy(FinanceTransaction.Properties.SUB_TYPE);
        Object[][] vals = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0]);
        if (vals == null || vals.length == 0) {
            return null;
        }
        ArrayList<AccountingSalesReport> tips = new ArrayList<AccountingSalesReport>();
        for (Object[] val : vals) {
            Price price = new Price((Number)val[0], 0.01);
            if (Price.ZERO_DOLLAR.equals(price)) continue;
            AccountingSalesReport report = AccountingSalesReport.generateBlankReport(shift);
            report.setNettSales(price);
            report.setGrossSales(price);
            report.setMemo("Tips for " + PersistenceManager.getByID(((Number)val[1]).longValue(), FinanceUnit.class).getLabel());
            report.setDiscount(Price.ZERO_DOLLAR);
            report.setSurcharge(Price.ZERO_DOLLAR);
            report.setGLAccount(BaseAccountingConfiguration.getInstance().getDefaultTipsGLCode());
            report.setAllocationMemoPrefix(memo);
            report.setTaxCode(TaxCode.getNotTaxable());
            report.setTaxAmount(Price.ZERO_DOLLAR);
            tips.add(report);
        }
        return tips;
    }
}

