/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.reports;

import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.util.Price;
import ordermate.database.finance.Shift;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.reports.AccountingReport;
import ordermate.database.integration.accounting.settings.GLAccount;

public class AccountingVoucherReport
implements AccountingReport {
    private Price amount = Price.ZERO_DOLLAR;
    private final FKReference<Shift> shift = new FKReference<Shift>(Shift.class);
    private final GLAccount glAccount;
    private final String memo;
    private final boolean topup;
    private final boolean reversal;

    public AccountingVoucherReport(GLAccount voucherGLAccount, String theMemo, boolean isTopup, boolean isReversal, Shift theShift) {
        this.glAccount = voucherGLAccount;
        this.memo = theMemo;
        this.topup = isTopup;
        this.reversal = isReversal;
        this.shift.set(theShift);
    }

    public boolean isTopup() {
        return this.topup;
    }

    public boolean isReversal() {
        return this.reversal;
    }

    public Price getAmount() {
        return this.amount;
    }

    public void setAmount(Price value) {
        this.amount = value;
    }

    @Override
    public TaxCode getTaxCode() {
        return TaxCode.getNotTaxable();
    }

    @Override
    public String getGlAccountCode() {
        return this.glAccount.getGlCode();
    }

    @Override
    public String getMemo() {
        return this.memo;
    }

    @Override
    public String getAllocationMemo() {
        return this.memo;
    }

    @Override
    public void setAllocationMemoPrefix(String prefix) {
    }

    @Override
    public String getAllocationMemoPrefix() {
        return null;
    }

    @Override
    public Price getTotal() {
        return this.amount;
    }

    @Override
    public long getRecordID() {
        return 0L;
    }

    @Override
    public GLAccount getGlAccount() {
        return this.glAccount;
    }

    @Override
    public GLAccount getGlAccountOrDefault() {
        return this.glAccount;
    }

    @Override
    public Shift getShift() {
        return (Shift)this.shift.get();
    }

    @Override
    public void addReport(AccountingReport reportToAdd) {
        if (reportToAdd instanceof AccountingVoucherReport) {
            this.amount = this.amount.add(((AccountingVoucherReport)reportToAdd).amount);
        }
    }

    @Override
    public boolean isReconciliationEntry() {
        return false;
    }

    @Override
    public void setReconciliationEntry(boolean reconciliation) {
    }
}

