/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.Shift;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.integration.accounting.reports.AccountingVoucherReport;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherConfigurationGLAccountLink;
import ordermate.database.reports.general.PriceReport;

public class AccountingVoucherReportMaker {
    public Map<Long, List<AccountingVoucherReport>> makeVoucherReports(Shift from, Shift to) {
        HashMap<Long, List<AccountingVoucherReport>> reportMap = new HashMap<Long, List<AccountingVoucherReport>>();
        List<Shift> shifts = PersistenceManager.getObjectList(Shift.class, new ObjectQuery().select(Shift.class).wherePropertyBetween(Shift.Properties.ID, from.getID(), to.getID()).orderBy(Shift.Properties.ID).toString(), null);
        for (Shift shift : shifts) {
            ArrayList<AccountingVoucherReport> nextBatch = new ArrayList<AccountingVoucherReport>();
            nextBatch.addAll(this.generateReports(shift, true, true));
            nextBatch.addAll(this.generateReports(shift, true, false));
            nextBatch.addAll(this.generateReports(shift, false, true));
            nextBatch.addAll(this.generateReports(shift, false, false));
            reportMap.put(shift.getID(), nextBatch);
        }
        return reportMap;
    }

    private List<AccountingVoucherReport> generateReports(Shift shift, boolean topup, boolean reversal) {
        String memo;
        String string = memo = topup ? "Voucher Topup" : "Voucher Reversal";
        if (reversal) {
            memo = memo + " Reversal";
        }
        List<GiftVoucherConfiguration> configs = PersistenceManager.getObjectList(GiftVoucherConfiguration.class, Query.select(GiftVoucherConfiguration.class).toString());
        ObjectQuery query = Query.select(GiftVoucherTransaction.Properties.ID);
        ArrayList<AccountingVoucherReport> reports = new ArrayList<AccountingVoucherReport>();
        GLAccount account = this.getGLAccountFor(null, topup);
        if (!topup) {
            query.selectFunc("-1 * SUM(amount) as price");
        } else {
            query.selectFunc("SUM(amount) as price");
        }
        query.not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).linkUsing(GiftVoucherTransaction.Properties.GIFT_VOUCHER).equals((PropertiedObject.Property)GiftVoucherTransaction.Properties.CONFIRMED, Boolean.TRUE).equals(GiftVoucherTransaction.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).equals(GiftVoucherTransaction.Properties.SHIFT, shift);
        if (!reversal) {
            query.isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
            if (topup) {
                query.greaterThan(GiftVoucherTransaction.Properties.AMOUNT, 0.0);
            } else {
                query.lessThan(GiftVoucherTransaction.Properties.AMOUNT, 0.0);
            }
        } else {
            query.not().isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
            if (topup) {
                query.lessThan(GiftVoucherTransaction.Properties.AMOUNT, 0.0);
            } else {
                query.greaterThan(GiftVoucherTransaction.Properties.AMOUNT, 0.0);
            }
        }
        AccountingVoucherReport report = new AccountingVoucherReport(account, memo, topup, reversal, shift);
        report.setAmount(PersistenceManager.getObject(PriceReport.class, query.toString()).getPrice());
        reports.add(report);
        return reports;
    }

    private GLAccount getGLAccountFor(GiftVoucherConfiguration config, boolean topup) {
        GLAccount account = null;
        if (topup) {
            if (config != null) {
                for (GiftVoucherConfigurationGLAccountLink link : config.getGlLinks()) {
                    if (!GiftVoucherTransaction.VoucherTransactionType.TOPUP.equals((Object)link.getType()) && !GiftVoucherTransaction.VoucherTransactionType.TOPUP_REVERSAL.equals((Object)link.getType())) continue;
                    account = link.getGlAccount();
                    break;
                }
            }
            if (account == null && (account = BaseAccountingConfiguration.getInstance().getDefaultVoucherTopupCode()) == null) {
                account = BaseAccountingConfiguration.getInstance().getDefaultSalesIncomeGLCode();
            }
        } else {
            if (config != null) {
                for (GiftVoucherConfigurationGLAccountLink link : config.getGlLinks()) {
                    if (!GiftVoucherTransaction.VoucherTransactionType.REDEEM.equals((Object)link.getType()) && !GiftVoucherTransaction.VoucherTransactionType.REDEEM_REVERSAL.equals((Object)link.getType())) continue;
                    account = link.getGlAccount();
                }
            }
            if (account == null && (account = BaseAccountingConfiguration.getInstance().getDefaultVoucherRedeemCode()) == null) {
                account = BaseAccountingConfiguration.getInstance().getDefaultFinanceGLCode();
            }
        }
        return account;
    }
}

