/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.settings;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.Map;

public enum AccountingClassType {
    BANK("Bank"),
    ACCOUNT_RECEIVABLE("Accounts Receivable"),
    OTHER_CURRENT_ASSET("Other Current Asset"),
    FIXED_ASSET("Fixed Asset"),
    OTHER_ASSET("Other Asset"),
    CREDIT_CARD("Credit Card"),
    ACCOUNTS_PAYABLE("Accounts Payable"),
    OTHER_CURRENT_LIABILITY("Other Current Liability"),
    LONG_TERM_LIABILITY("Long Term Liability"),
    OTHER_LIABILITY("Other Liability"),
    EQUITY("Equity"),
    INCOME("Income"),
    COST_OF_SALES("Cost Of Sales"),
    EXPENSE("Expense"),
    OTHER_INCOME("Other Income"),
    OTHER_EXPENSE("Other Expense"),
    OTHER("Other");

    private String description;
    public static final Map<String, AccountingClassType> register;

    private AccountingClassType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static AccountingClassType getEnumForDescription(String desc) {
        for (AccountingClassType type : AccountingClassType.values()) {
            if (!type.getDescription().equals(desc)) continue;
            return type;
        }
        throw new IllegalArgumentException();
    }

    static {
        register = PersistentEnumeration.buildRegister(AccountingClassType.values());
    }
}

