/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.settings;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.reference.SingletonReference;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.reports.accounting.GLType;
import ordermate.reports.accounting.InvoiceDateMethod;
import ordermate.reports.accounting.InvoiceGLGroup;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_acc_settings")
@AccessType(value="property")
@DiscriminatorValue(value="ALL")
@DBMapping(value=DBMapping.Mapping.Row)
public class BaseAccountingConfiguration
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String invoiceTaxCode;
    private String invoiceExpenseDescription;
    private String customerAccountTaxCode;
    private String customerAccountDescription;
    private String customerAccountJournalMemo;
    private String customerAccountIncludeTax;
    private InvoiceGLGroup invoiceGLGroup;
    private InvoiceDateMethod invoiceDateMethod = InvoiceDateMethod.Invoice;
    private Reference<GLAccount> reconciliationVarianceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationVarianceCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationOverringGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationOverringCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> customerAccountGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultSalesIncomeGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultCOGsGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultFinanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultDebtorGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultDiscountCogsGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultSalesSurchargeGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultInvoiceGlCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationPettyCashGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationPettyCashCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationCashVarianceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationCashVarianceCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationCreditVarianceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationCreditVarianceCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationTipsVarianceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationTipsVarianceCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationCashOutVarianceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationCashOutVarianceCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationWebVarianceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> reconciliationWebVarianceCounterbalanceGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultTipsGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> balanceAdjustmentGLCode = new FKReference<GLAccount>(GLAccount.class);
    private static Reference<BaseAccountingConfiguration> instance = new SingletonReference<BaseAccountingConfiguration>(BaseAccountingConfiguration.class);
    private Reference<GLAccount> defaultStockCOGsGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultStockWastageGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultStockAdjustmentGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultStockTransferGLCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultVoucherTopupCode = new FKReference<GLAccount>(GLAccount.class);
    private Reference<GLAccount> defaultVoucherRedeemCode = new FKReference<GLAccount>(GLAccount.class);

    public static BaseAccountingConfiguration getInstance() {
        return instance.get();
    }

    @Column(name="Invoice Tax Code")
    public String getInvoiceTaxCode() {
        return this.invoiceTaxCode;
    }

    public void setInvoiceTaxCode(String invoiceTaxCode) {
        this.invoiceTaxCode = invoiceTaxCode;
    }

    @Column(name="Invoice Expense Description")
    public String getInvoiceExpenseDescription() {
        return this.invoiceExpenseDescription;
    }

    public void setInvoiceExpenseDescription(String invoiceExpenseDescription) {
        this.invoiceExpenseDescription = invoiceExpenseDescription;
    }

    @Column(name="Customer Account Tax Code")
    public String getCustomerAccountTaxCode() {
        return this.customerAccountTaxCode;
    }

    public void setCustomerAccountTaxCode(String customerAccountTaxCode) {
        this.customerAccountTaxCode = customerAccountTaxCode;
    }

    @Column(name="Customer Account Description")
    public String getCustomerAccountDescription() {
        return this.customerAccountDescription;
    }

    public void setCustomerAccountDescription(String customerAccountDescription) {
        this.customerAccountDescription = customerAccountDescription;
    }

    @Column(name="Customer Account Journal Memo")
    public String getCustomerAccountJournalMemo() {
        return this.customerAccountJournalMemo;
    }

    public void setCustomerAccountJournalMemo(String customerAccountJournalMemo) {
        this.customerAccountJournalMemo = customerAccountJournalMemo;
    }

    @Column(name="Customer Account Include Tax")
    public String getCustomerAccountIncludeTax() {
        return this.customerAccountIncludeTax;
    }

    public void setCustomerAccountIncludeTax(String customerAccountIncludeTax) {
        this.customerAccountIncludeTax = customerAccountIncludeTax;
    }

    @Column(name="Invoice GL Group")
    @Enumerated(value=EnumType.STRING)
    public InvoiceGLGroup getInvoiceGLGroup() {
        return this.invoiceGLGroup;
    }

    public void setInvoiceGLGroup(InvoiceGLGroup invoiceGLGroup) {
        this.invoiceGLGroup = invoiceGLGroup;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            throw new IllegalStateException("Singleton so a new instance must not be created.");
        }
        PersistenceManager.save(this);
        this.clearCache();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Not supported for a singleton.");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public void clearCache() {
        instance.collapse();
    }

    @Column(name="Reconciliation Variance GL Code")
    public GLAccount getReconciliationVarianceGLCode() {
        return this.reconciliationVarianceGLCode.get();
    }

    public void setReconciliationVarianceGLCode(GLAccount glAccountConfiguration) {
        this.reconciliationVarianceGLCode.set(glAccountConfiguration);
    }

    @Column(name="Reconciliation Variance Counterbalance GL Code")
    public GLAccount getReconciliationVarianceCounterbalanceGLCode() {
        return this.reconciliationVarianceCounterbalanceGLCode.get();
    }

    public void setReconciliationVarianceCounterbalanceGLCode(GLAccount glAccountConfiguration) {
        this.reconciliationVarianceCounterbalanceGLCode.set(glAccountConfiguration);
    }

    @Column(name="Reconciliation Overring GL Code")
    public GLAccount getReconciliationOverringGLCode() {
        return this.reconciliationOverringGLCode.get();
    }

    public void setReconciliationOverringGLCode(GLAccount glAccountConfiguration) {
        this.reconciliationOverringGLCode.set(glAccountConfiguration);
    }

    @Column(name="Reconciliation Overring Counterbalance GL Code")
    public GLAccount getReconciliationOverringCounterbalanceGLCode() {
        return this.reconciliationOverringCounterbalanceGLCode.get();
    }

    public void setReconciliationOverringCounterbalanceGLCode(GLAccount glAccountConfiguration) {
        this.reconciliationOverringCounterbalanceGLCode.set(glAccountConfiguration);
    }

    public GLAccount getCustomerAccountGLCode() {
        return this.customerAccountGLCode.get();
    }

    public void setCustomerAccountGLCode(GLAccount glAccountConfiguration) {
        this.customerAccountGLCode.set(glAccountConfiguration);
    }

    public GLAccount getDefaultSalesIncomeGLCode() {
        return this.defaultSalesIncomeGLCode.get();
    }

    public void setDefaultSalesIncomeGLCode(GLAccount glAccountConfiguration) {
        this.defaultSalesIncomeGLCode.set(glAccountConfiguration);
    }

    public GLAccount getDefaultCOGsGLCode() {
        return this.defaultCOGsGLCode.get();
    }

    public void setDefaultCOGsGLCode(GLAccount glAccountConfiguration) {
        this.defaultCOGsGLCode.set(glAccountConfiguration);
    }

    public GLAccount getDefaultFinanceGLCode() {
        return this.defaultFinanceGLCode.get();
    }

    public void setDefaultFinanceGLCode(GLAccount glAccountConfiguration) {
        this.defaultFinanceGLCode.set(glAccountConfiguration);
    }

    public GLAccount getDefaultDebtorGLCode() {
        return this.defaultDebtorGLCode.get();
    }

    public void setDefaultDebtorGLCode(GLAccount glAccountConfiguration) {
        this.defaultDebtorGLCode.set(glAccountConfiguration);
    }

    public GLAccount getDefaultDiscountCogsGLCode() {
        return this.defaultDiscountCogsGLCode.get();
    }

    public void setDefaultDiscountCogsGLCode(GLAccount glAccountConfiguration) {
        this.defaultDiscountCogsGLCode.set(glAccountConfiguration);
    }

    public GLAccount getDefaultSalesSurchargeGLCode() {
        return this.defaultSalesSurchargeGLCode.get();
    }

    public void setDefaultSalesSurchargeGLCode(GLAccount glAccountConfiguration) {
        this.defaultSalesSurchargeGLCode.set(glAccountConfiguration);
    }

    public GLAccount getDefaultInvoiceGlCode() {
        return this.defaultInvoiceGlCode.get();
    }

    public void setDefaultInvoiceGlCode(GLAccount glAccountConfiguration) {
        this.defaultInvoiceGlCode.set(glAccountConfiguration);
    }

    @Transient
    public GLAccount getDefaultSalesIncomeAccount() {
        return new GLAccount(this.defaultSalesIncomeGLCode.get().getGlCode(), "POS Sales", "Account to record general sales data from the ordermate point of sale system");
    }

    @Column(name="Reconciliation Petty Cash GL Code")
    public GLAccount getReconciliationPettyCashGLCode() {
        return this.reconciliationPettyCashGLCode.get();
    }

    public void setReconciliationPettyCashGLCode(GLAccount glAccountConfiguration) {
        this.reconciliationPettyCashGLCode.set(glAccountConfiguration);
    }

    @Column(name="Reconciliation Petty Cash Counterbalance GL Code")
    public GLAccount getReconciliationPettyCashCounterbalanceGLCode() {
        return this.reconciliationPettyCashCounterbalanceGLCode.get();
    }

    public void setReconciliationPettyCashCounterbalanceGLCode(GLAccount glAccountConfiguration) {
        this.reconciliationPettyCashCounterbalanceGLCode.set(glAccountConfiguration);
    }

    @Column(name="Reconciliation Cash Variance GL Code")
    public GLAccount getReconciliationCashVarianceGLCode() {
        return this.reconciliationCashVarianceGLCode.get();
    }

    public void setReconciliationCashVarianceGLCode(GLAccount reconciliationCashVarianceGLCode) {
        this.reconciliationCashVarianceGLCode.set(reconciliationCashVarianceGLCode);
    }

    @Column(name="Reconciliation Cash Variance Counterbalance GL Code")
    public GLAccount getReconciliationCashVarianceCounterbalanceGLCode() {
        return this.reconciliationCashVarianceCounterbalanceGLCode.get();
    }

    public void setReconciliationCashVarianceCounterbalanceGLCode(GLAccount reconciliationCashVarianceCounterbalanceGLCode) {
        this.reconciliationCashVarianceCounterbalanceGLCode.set(reconciliationCashVarianceCounterbalanceGLCode);
    }

    @Column(name="Reconciliation Credit Variance GL Code")
    public GLAccount getReconciliationCreditVarianceGLCode() {
        return this.reconciliationCreditVarianceGLCode.get();
    }

    public void setReconciliationCreditVarianceGLCode(GLAccount reconciliationCreditVarianceGLCode) {
        this.reconciliationCreditVarianceGLCode.set(reconciliationCreditVarianceGLCode);
    }

    @Column(name="Reconciliation Credit Variance Counterbalance GL Code")
    public GLAccount getReconciliationCreditVarianceCounterbalanceGLCode() {
        return this.reconciliationCreditVarianceCounterbalanceGLCode.get();
    }

    public void setReconciliationCreditVarianceCounterbalanceGLCode(GLAccount reconciliationCreditVarianceCounterbalanceGLCode) {
        this.reconciliationCreditVarianceCounterbalanceGLCode.set(reconciliationCreditVarianceCounterbalanceGLCode);
    }

    @Column(name="Reconciliation Tips Variance GL Code")
    public GLAccount getReconciliationTipsVarianceGLCode() {
        return this.reconciliationTipsVarianceGLCode.get();
    }

    public void setReconciliationTipsVarianceGLCode(GLAccount reconciliationTipsVarianceGLCode) {
        this.reconciliationTipsVarianceGLCode.set(reconciliationTipsVarianceGLCode);
    }

    @Column(name="Reconciliation Tips Variance Counterbalance GL Code")
    public GLAccount getReconciliationTipsVarianceCounterbalanceGLCode() {
        return this.reconciliationTipsVarianceCounterbalanceGLCode.get();
    }

    public void setReconciliationTipsVarianceCounterbalanceGLCode(GLAccount reconciliationTipsVarianceCounterbalanceGLCode) {
        this.reconciliationTipsVarianceCounterbalanceGLCode.set(reconciliationTipsVarianceCounterbalanceGLCode);
    }

    @Column(name="Reconciliation Cash Out Variance GL Code")
    public GLAccount getReconciliationCashOutVarianceGLCode() {
        return this.reconciliationCashOutVarianceGLCode.get();
    }

    public void setReconciliationCashOutVarianceGLCode(GLAccount reconciliationCashOutVarianceGLCode) {
        this.reconciliationCashOutVarianceGLCode.set(reconciliationCashOutVarianceGLCode);
    }

    @Column(name="Reconciliation Cash Out Variance Counterbalance GL Code")
    public GLAccount getReconciliationCashOutVarianceCounterbalanceGLCode() {
        return this.reconciliationCashOutVarianceCounterbalanceGLCode.get();
    }

    public void setReconciliationCashOutVarianceCounterbalanceGLCode(GLAccount reconciliationCashOutVarianceCounterbalanceGLCode) {
        this.reconciliationCashOutVarianceCounterbalanceGLCode.set(reconciliationCashOutVarianceCounterbalanceGLCode);
    }

    @Column(name="Reconciliation Web Variance GL Code")
    public GLAccount getReconciliationWebVarianceGLCode() {
        return this.reconciliationWebVarianceGLCode.get();
    }

    public void setReconciliationWebVarianceGLCode(GLAccount reconciliationWebVarianceGLCode) {
        this.reconciliationWebVarianceGLCode.set(reconciliationWebVarianceGLCode);
    }

    @Column(name="Reconciliation Web Variance Counterbalance GL Code")
    public GLAccount getReconciliationWebVarianceCounterbalanceGLCode() {
        return this.reconciliationWebVarianceCounterbalanceGLCode.get();
    }

    public void setReconciliationWebVarianceCounterbalanceGLCode(GLAccount reconciliationWebVarianceCounterbalanceGLCode) {
        this.reconciliationWebVarianceCounterbalanceGLCode.set(reconciliationWebVarianceCounterbalanceGLCode);
    }

    @Column(name="Balance Adjustment GL Code")
    public GLAccount getBalanceAdjustmentGLCode() {
        return this.balanceAdjustmentGLCode.get();
    }

    public void setBalanceAdjustmentGLCode(GLAccount balanceAdjustmentGLCode) {
        this.balanceAdjustmentGLCode.set(balanceAdjustmentGLCode);
    }

    @Column(name="Invoice Date Method")
    @Enumerated(value=EnumType.STRING)
    public InvoiceDateMethod getInvoiceDateMethod() {
        return this.invoiceDateMethod;
    }

    public void setInvoiceDateMethod(InvoiceDateMethod invoiceDateMethod) {
        this.invoiceDateMethod = invoiceDateMethod;
    }

    public GLAccount getDefaultStockCOGsGLCode() {
        return this.defaultStockCOGsGLCode.get();
    }

    public void setDefaultStockCOGsGLCode(GLAccount glAccount) {
        this.defaultStockCOGsGLCode.set(glAccount);
    }

    public GLAccount getDefaultStockWastageGLCode() {
        return this.defaultStockWastageGLCode.get();
    }

    public void setDefaultStockWastageGLCode(GLAccount glAccount) {
        this.defaultStockWastageGLCode.set(glAccount);
    }

    public GLAccount getDefaultStockAdjustmentGLCode() {
        return this.defaultStockAdjustmentGLCode.get();
    }

    public void setDefaultStockAdjustmentGLCode(GLAccount glAccount) {
        this.defaultStockAdjustmentGLCode.set(glAccount);
    }

    public GLAccount getDefaultStockTransferGLCode() {
        return this.defaultStockTransferGLCode.get();
    }

    public void setDefaultStockTransferGLCode(GLAccount glAccount) {
        this.defaultStockTransferGLCode.set(glAccount);
    }

    public GLAccount getGLCodeForType(GLType type) {
        switch (type) {
            case COGS: {
                return this.getDefaultStockCOGsGLCode();
            }
            case Wastage: {
                return this.getDefaultStockWastageGLCode();
            }
            case Adjustment: {
                return this.getDefaultStockAdjustmentGLCode();
            }
            case Transfer: {
                return this.getDefaultStockTransferGLCode();
            }
        }
        throw new IllegalArgumentException("There is no corresponding GL code for the given GL Type: " + (Object)((Object)type));
    }

    public GLAccount getDefaultVoucherTopupCode() {
        return this.defaultVoucherTopupCode.get();
    }

    public void setDefaultVoucherTopupCode(GLAccount glAccount) {
        this.defaultVoucherTopupCode.set(glAccount);
    }

    public GLAccount getDefaultVoucherRedeemCode() {
        return this.defaultVoucherRedeemCode.get();
    }

    public void setDefaultVoucherRedeemCode(GLAccount glAccount) {
        this.defaultVoucherRedeemCode.set(glAccount);
    }

    public GLAccount getDefaultVoucherGLCode(GiftVoucherTransaction.VoucherTransactionType type) {
        switch (type) {
            case TOPUP: {
                return this.getDefaultVoucherTopupCode();
            }
            case REDEEM: {
                return this.getDefaultVoucherRedeemCode();
            }
        }
        return this.getDefaultVoucherTopupCode();
    }

    public GLAccount getDefaultTipsGLCode() {
        return this.defaultTipsGLCode.get();
    }

    public void setDefaultTipsGLCode(GLAccount code) {
        this.defaultTipsGLCode.set(code);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> INVOICE_TAX_CODE;
        public PropertiedObject.Property<String> INVOICE_EXPENSE_DESCRIPTION;
        public PropertiedObject.Property<String> CUSTOMER_ACCOUNT_TAX_CODE;
        public PropertiedObject.Property<String> CUSTOMER_ACCOUNT_DESCRIPTION;
        public PropertiedObject.Property<String> CUSTOMER_ACCOUNT_JOURNAL_MEMO;
        public PropertiedObject.Property<String> CUSTOMER_ACCOUNT_INCLUDE_TAX;
        public PropertiedObject.Property<InvoiceGLGroup> INVOICE_GL_GROUP;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_VARIANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_VARIANCE_COUNTER_BALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_OVERRING_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_OVERRING_COUNTER_BALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> CUSTOMER_ACCOUNT_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_SALES_INCOME_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_COGS_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_FINANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_DEBTOR_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_DISCOUNT_COGS_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_SALES_SURCHARGE_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_INVOICE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_PETTY_CASH_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_PETTY_CASH_COUNTERBALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_CASH_VARIANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_CASH_VARIANCE_COUNTERBALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_CREDIT_VARIANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_CREDIT_VARIANCE_COUNTERBALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_TIPS_VARIANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_TIPS_VARIANCE_COUNTERBALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_CASH_OUT_VARIANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_CASH_OUT_VARIANCE_COUNTERBALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_WEB_VARIANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> RECONCILIATION_WEB_VARIANCE_COUNTERBALANCE_GL_CODE;
        public PropertiedObject.Property<GLAccount> BALANCE_ADJUSTMENT_GL_CODE;
        public PropertiedObject.Property<InvoiceDateMethod> INVOICE_DATE_METHOD;
        public PropertiedObject.Property<GLAccount> DEFAULT_STOCK_COGS_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_STOCK_WASTAGE_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_STOCK_ADJUSTMENT_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_STOCK_TRANSFER_GL_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_VOUCHER_TOPUP_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_VOUCHER_REDEEM_CODE;
        public PropertiedObject.Property<GLAccount> DEFAULT_TIPS_GL_CODE;
    }
}

