/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.settings;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.accounting.settings.AccountingClassType;
import ordermate.database.integration.accounting.settings.CashFlowClassification;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_acc_gl_account")
@AccessType(value="property")
public class GLAccount
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private AccountingClassType type;
    private String name;
    private String description;
    private String glCode;
    private boolean exported;
    private boolean grouped;
    private CashFlowClassification cashFlowClassification;
    private Reference<TaxCode> defaultTaxCode;

    public GLAccount() {
        this.defaultTaxCode = this.createReference(GLAccount.Properties.DEFAULT_TAX_CODE);
    }

    public GLAccount(String glCode, String name, String description) {
        this.defaultTaxCode = this.createReference(GLAccount.Properties.DEFAULT_TAX_CODE);
        this.glCode = glCode;
        this.name = name;
        this.description = description;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="gl_code")
    public String getGlCode() {
        return this.glCode;
    }

    public void setGlCode(String glCode) {
        this.glCode = glCode;
    }

    @Column(name="exported")
    public boolean isExported() {
        return this.exported;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Column(name="grouped")
    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    public AccountingClassType getType() {
        return this.type;
    }

    public void setType(AccountingClassType type) {
        this.type = type;
    }

    @Transient
    public void setType(String type) {
        this.type = AccountingClassType.valueOf(type);
    }

    @Transient
    public static GLAccount getGLAccountForGLCode(String glCode) {
        return PersistenceManager.getObject(GLAccount.class, Query.select(GLAccount.class).equals(GLAccount.Properties.GL_CODE, glCode).toString());
    }

    @Transient
    public static GLAccount getGLAccountForName(String name) {
        return PersistenceManager.getObject(GLAccount.class, Query.select(GLAccount.class).equals(GLAccount.Properties.NAME, name).toString());
    }

    @Transient
    public static List<GLAccount> getGLAccounts() {
        return PersistenceManager.getObjectList(GLAccount.class, Query.select(GLAccount.class).toString(), null);
    }

    @Transient
    public static List<GLAccount> getAllGLAccountsForAccountingType(AccountingClassType type) {
        return PersistenceManager.getObjectList(GLAccount.class, Query.select(GLAccount.class).equals(GLAccount.Properties.TYPE, (Object)type).toString(), null);
    }

    @Override
    public String toString() {
        if (this.glCode != null) {
            return this.glCode;
        }
        return "";
    }

    @Column(name="cash_flow_classification")
    @Enumerated(value=EnumType.STRING)
    public CashFlowClassification getCashFlowClassification() {
        return this.cashFlowClassification;
    }

    public void setCashFlowClassification(CashFlowClassification cashFlowClassification) {
        this.cashFlowClassification = cashFlowClassification;
    }

    @ManyToOne
    @JoinColumn(name="fk_system_tax_code", referencedColumnName="ID")
    public TaxCode getDefaultTaxCode() {
        return this.defaultTaxCode.get();
    }

    public void setDefaultTaxCode(TaxCode defaultTaxCode) {
        this.defaultTaxCode.set(defaultTaxCode);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<AccountingClassType> TYPE;
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property<String> GL_CODE;
        public PropertiedObject.Property<Boolean> EXPORTED;
        public PropertiedObject.Property<Boolean> GROUPED;
        public PropertiedObject.Property<CashFlowClassification> CASH_FLOW_CLASSIFICATION;
        public PropertiedObject.Property<TaxCode> DEFAULT_TAX_CODE;
    }
}

