/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.settings;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.reference.SingletonReference;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import ordermate.database.integration.accounting.AccountNumberExportMethod;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import org.hibernate.annotations.AccessType;

@Entity
@AccessType(value="property")
@DiscriminatorValue(value="Quickbooks")
public class QuickbooksConfiguration
extends BaseAccountingConfiguration {
    public static final String TYPE = FinanceExportStyle.Quickbooks.name();
    public static final Props Properties = new Props();
    private static final Reference<QuickbooksConfiguration> instance = new SingletonReference<QuickbooksConfiguration>(QuickbooksConfiguration.class);
    private String companyName;
    private String companyCreationTime;
    private AccountNumberExportMethod accountNumberExportMethod = AccountNumberExportMethod.ACCOUNT_NAME;

    public static QuickbooksConfiguration getInstance() {
        return instance.get();
    }

    @Column(name="Company Name")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Column(name="Company Creation Time")
    public String getCompanyCreationTime() {
        return this.companyCreationTime;
    }

    public void setCompanyCreationTime(String companyCreationTime) {
        this.companyCreationTime = companyCreationTime;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="Account Number Export Method")
    public AccountNumberExportMethod getAccountNumberExportMethod() {
        return this.accountNumberExportMethod;
    }

    public void setAccountNumberExportMethod(AccountNumberExportMethod accountNumberExportMethod) {
        this.accountNumberExportMethod = accountNumberExportMethod;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        instance.collapse();
    }

    public static class Props
    extends BaseAccountingConfiguration.Props {
        public PropertiedObject.Property<String> COMPANY_NAME;
        public PropertiedObject.Property<String> COMPANY_CREATION_TIME;
        public PropertiedObject.Property<AccountNumberExportMethod> ACCOUNT_NUMBER_EXPORT_METHOD;
    }
}

