/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.accounting.settings;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.reference.SingletonReference;
import au.com.ordermate.util.StringUtils;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.integration.accounting.settings.BaseAccountingConfiguration;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import org.hibernate.annotations.AccessType;

@Entity
@AccessType(value="property")
@DiscriminatorValue(value="Xero")
public class XeroConfiguration
extends BaseAccountingConfiguration {
    public static final String TYPE = FinanceExportStyle.Xero.name();
    public static final Props Properties = new Props();
    private static final Reference<XeroConfiguration> instance = new SingletonReference<XeroConfiguration>(XeroConfiguration.class);
    private String trackingCategoryName;
    private String trackingCategoryOption;

    public static XeroConfiguration getInstance() {
        return instance.get();
    }

    @Column(name="Tracking Category Name")
    public String getTrackingCategoryName() {
        return this.trackingCategoryName;
    }

    public void setTrackingCategoryName(String trackingCategoryName) {
        this.trackingCategoryName = trackingCategoryName;
    }

    @Column(name="Tracking Category Option")
    public String getTrackingCategoryOption() {
        return this.trackingCategoryOption;
    }

    public void setTrackingCategoryOption(String trackingCategoryOption) {
        this.trackingCategoryOption = trackingCategoryOption;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        instance.collapse();
    }

    @Transient
    public boolean hasValues() {
        return !StringUtils.isEmpty(this.getTrackingCategoryName()) && !StringUtils.isEmpty(this.getTrackingCategoryOption());
    }

    public static class Props
    extends BaseAccountingConfiguration.Props {
        public PropertiedObject.Property<String> TRACKING_CATEGORY_NAME;
        public PropertiedObject.Property<String> TRACKING_CATEGORY_OPTION;
    }
}

