/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.adyen;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.adyen.AdyenCurrencyCode;
import ordermate.database.integration.adyen.AdyenManagementUrlType;

@Entity
@Table(name="config_integration_adyen")
public class AdyenIntegrationConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private AdyenManagementUrlType managementUrl;
    private String storeIdentifier;
    private String apiCredential;
    private AdyenCurrencyCode currencyCode;
    private String checkoutPrefix;
    private String liveEndpoint;
    private Double surchargeRate;
    private boolean configured;
    private Reference<CashDrawer> cashdrawer;
    private static Reference<AdyenIntegrationConfig> instance = new LocalCachedReference<AdyenIntegrationConfig>(new QueryReference<AdyenIntegrationConfig>(AdyenIntegrationConfig.class, Query.select(AdyenIntegrationConfig.class)));

    public AdyenIntegrationConfig() {
        this.cashdrawer = this.createReference(AdyenIntegrationConfig.Properties.CASHDRAWER);
    }

    @Transient
    public boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean isConfigured) {
        this.configured = isConfigured;
    }

    public static AdyenIntegrationConfig getInstance() {
        return instance.get();
    }

    public static void refreshReference() {
        instance.set((AdyenIntegrationConfig)PersistenceManager.reacquire(instance.get()));
    }

    @Column(name="management_url")
    public AdyenManagementUrlType getManagementUrl() {
        return this.managementUrl;
    }

    @Transient
    public String getManagementUrlString() {
        return this.managementUrl.getUrl();
    }

    @Column(name="store_identifier")
    public String getStoreIdentifier() {
        return this.storeIdentifier;
    }

    @Column(name="api_credential")
    public String getApiCredential() {
        return this.apiCredential;
    }

    public void setManagementUrl(AdyenManagementUrlType managementUrl) {
        this.managementUrl = managementUrl;
    }

    public void setManagementUrlLabel(String managementUrl) {
        this.managementUrl.setUrl(managementUrl);
    }

    @Transient
    public void setStoreIdentifier(String storeId) {
        this.storeIdentifier = storeId;
    }

    public void setApiCredential(String apiCredential) {
        this.apiCredential = apiCredential;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Transient
    public AdyenCurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(AdyenCurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    @Transient
    public String getCheckoutPrefix() {
        return this.checkoutPrefix;
    }

    public void setCheckoutPrefix(String checkoutPrefix) {
        this.checkoutPrefix = checkoutPrefix;
    }

    @Transient
    public String getLiveEndpoint() {
        return this.liveEndpoint;
    }

    public void setLiveEndpoint(String liveEndpoint) {
        this.liveEndpoint = liveEndpoint;
    }

    @Transient
    public Double getSurchargeRate() {
        return this.surchargeRate;
    }

    public void setSurchargeRate(Double surchargeRate) {
        this.surchargeRate = surchargeRate;
    }

    @Transient
    public CashDrawer getCashdrawer() {
        return this.cashdrawer.get();
    }

    public void setCashdrawer(CashDrawer value) {
        this.cashdrawer.set(value);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<AdyenManagementUrlType> MANAGEMENT_URL;
        public PropertiedObject.Property<String> STORE_IDENTIFIER;
        public PropertiedObject.Property<String> API_CREDENTIAL;
        public PropertiedObject.Property<AdyenCurrencyCode> CURRENCY_CODE;
        public PropertiedObject.Property<String> CHECKOUT_PREFIX;
        public PropertiedObject.Property<String> LIVE_ENDPOINT;
        public PropertiedObject.Property<Double> SURCHARGE_RATE;
        public PropertiedObject.Property<CashDrawer> CASHDRAWER;
        public PropertiedObject.Property<Boolean> CONFIGURED;
    }
}

