/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.adyen;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.Date;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Customer;

public class AdyenLoyalty
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String cardAlias;
    private String cardBin;
    private String cardBrand;
    private Reference<FinanceTransaction> transaction;
    private Reference<Customer> customer;
    private String systemState;
    private Date creationTime;
    private transient EventContext currentSaveContext;

    public AdyenLoyalty() {
        this.transaction = this.createReference(AdyenLoyalty.Properties.TRANSACTION);
        this.customer = this.createReference(AdyenLoyalty.Properties.CUSTOMER);
        this.systemState = "ACTIVE";
    }

    public AdyenLoyalty(String alias, String bin, String brand) {
        this.transaction = this.createReference(AdyenLoyalty.Properties.TRANSACTION);
        this.customer = this.createReference(AdyenLoyalty.Properties.CUSTOMER);
        this.systemState = "ACTIVE";
        this.cardAlias = alias;
        this.cardBin = bin;
        this.cardBrand = brand;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.currentSaveContext = (EventContext)context;
    }

    @Transient
    public EventContext getCurrentSaveContext() {
        return this.currentSaveContext;
    }

    @Override
    public void saveChild() {
        if (!this.isPersistent()) {
            if (this.getTransaction().getID() == null) {
                this.getTransaction().saveChild();
            }
            if (this.getCustomer() != null && this.getCustomer().getID() == null) {
                this.getCustomer().save();
            }
            if (this.creationTime == null) {
                this.setCreationTime(new Date());
            }
        }
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.systemState = "DELETED";
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return false;
    }

    @Transient
    public String getCardBrand() {
        return this.cardBrand;
    }

    @Transient
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCardBrand(String cardBrand) {
        this.cardBrand = cardBrand;
    }

    public void setCustomer(Customer customer) {
        this.customer.set(customer);
    }

    public void setCurrentSaveContext(EventContext currentSaveContext) {
        this.currentSaveContext = currentSaveContext;
    }

    @Transient
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Transient
    public FinanceTransaction getTransaction() {
        return this.transaction.get();
    }

    public void setTransaction(FinanceTransaction transaction) {
        this.transaction.set(transaction);
    }

    @Transient
    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @Transient
    public String getCardAlias() {
        return this.cardAlias;
    }

    @Transient
    public String getCardBin() {
        return this.cardBin;
    }

    public void setCardAlias(String cardAlias) {
        this.cardAlias = cardAlias;
    }

    public void setCardBin(String cardBin) {
        this.cardBin = cardBin;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> CARD_ALIAS;
        public PropertiedObject.Property<String> CARD_BIN;
        public PropertiedObject.Property<String> CARD_BRAND;
        public PropertiedObject.Property<FinanceTransaction> TRANSACTION;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Date> CREATION_TIME;
    }
}

