/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.bartabs;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.transactions.FinanceUnit;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_integration_bartabs")
@AccessType(value="property")
public class BarTabsConfiguration
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String name;
    private String vendorId;
    private String payButtonTxt;
    private String icon;
    private boolean allowsPayOff;
    private String url;
    private String systemState = "ACTIVE";
    private Reference<FinanceUnit> financeUnit;
    private String merchantId;
    private boolean enabled;
    private String secretKey;
    private int pollInterval;
    private boolean fullIntegration;
    private boolean forceCloseTabsEndOfDay;

    public BarTabsConfiguration() {
        this.financeUnit = this.createReference(BarTabsConfiguration.Properties.FINANCE_UNIT);
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="vendor_id")
    public String getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    @Column(name="pay_button_txt")
    public String getPayButtonTxt() {
        return this.payButtonTxt;
    }

    public void setPayButtonTxt(String payButtonTxt) {
        this.payButtonTxt = payButtonTxt;
    }

    @Column(name="icon")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Column(name="allows_pay_off")
    public boolean isAllowsPayOff() {
        return this.allowsPayOff;
    }

    public void setAllowsPayOff(boolean allowsPayOff) {
        this.allowsPayOff = allowsPayOff;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Transient
    public static BarTabsConfiguration getBarTabConfigForVendorId(String vendorId) {
        return PersistenceManager.getObject(BarTabsConfiguration.class, Query.select(BarTabsConfiguration.class).active(BarTabsConfiguration.class).equals(BarTabsConfiguration.Properties.VENDOR_ID, vendorId).toString());
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newUrl) {
        if (newUrl != null) {
            this.url = newUrl;
            if (!this.url.endsWith("/")) {
                this.url = this.url + "/";
            }
        }
    }

    @ManyToOne
    @JoinColumn(name="fk_finance_unit")
    public FinanceUnit getFinanceUnit() {
        return this.financeUnit.get();
    }

    public void setFinanceUnit(FinanceUnit financeUnit) {
        this.financeUnit.set(financeUnit);
    }

    @Column(name="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Column(name="secret_key")
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Column(name="poll_interval_ms")
    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    @Column(name="full_integration")
    public boolean isFullIntegration() {
        return this.fullIntegration;
    }

    @Column(name="force_close_tabs_end_of_day")
    public boolean isForceCloseTabsEndOfDay() {
        return this.forceCloseTabsEndOfDay;
    }

    public void setForceCloseTabsEndOfDay(boolean forceCloseTabsEndOfDay) {
        this.forceCloseTabsEndOfDay = forceCloseTabsEndOfDay;
    }

    protected void setFullIntegration(boolean fullIntegration) {
        this.fullIntegration = fullIntegration;
    }

    public void setMerchantId(String value) {
        this.merchantId = value;
    }

    @Column(name="merchant_id")
    public String getMerchantId() {
        return this.merchantId;
    }

    public static List<BarTabsConfiguration> getAllActiveThirdPartyVendors() {
        return PersistenceManager.getObjectList(BarTabsConfiguration.class, Query.select(BarTabsConfiguration.class).active(BarTabsConfiguration.class).equals(BarTabsConfiguration.Properties.ENABLED, 1.0).equals(BarTabsConfiguration.Properties.FULL_INTEGRATION, 1.0).toString());
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<String> VENDOR_ID;
        public PropertiedObject.Property<String> PAY_BUTTON_TXT;
        public PropertiedObject.Property<String> ICON;
        public PropertiedObject.Property<Boolean> ALLOWS_PAY_OFF;
        public PropertiedObject.Property<String> URL;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<FinanceUnit> FINANCE_UNIT;
        public PropertiedObject.Property<Boolean> ENABLED;
        public PropertiedObject.Property<String> SECRET_KEY;
        public PropertiedObject.Property<Integer> POLL_INTERVAL;
        public PropertiedObject.Property<Boolean> FULL_INTEGRATION;
        public PropertiedObject.Property<Boolean> FORCE_CLOSE_TABS_END_OF_DAY;
        public PropertiedObject.Property<String> MERCHANT_ID;
    }
}

