/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.cloudback;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.integration.cloudback.CloudBackProperty;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;

@Entity
@Table(name="config_integration_cloudback")
public class CloudBackConfig
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private boolean enabled = true;
    private CloudServerType cloudServerType;
    private String label;
    private Reference<WebserviceIntegrationConfig> webConfig;
    private PersistentWriteableList<CloudBackProperty> cloudProperties;

    @Deprecated
    public CloudBackConfig() {
        this.webConfig = this.createReference(CloudBackConfig.Properties.WEB_CONFIG);
        this.cloudProperties = this.createWriteableList(CloudBackConfig.Properties.CLOUD_PROPERTIES);
    }

    public CloudBackConfig(CloudServerType type) {
        this.webConfig = this.createReference(CloudBackConfig.Properties.WEB_CONFIG);
        this.cloudProperties = this.createWriteableList(CloudBackConfig.Properties.CLOUD_PROPERTIES);
        this.cloudServerType = type;
        this.label = type.name();
        this.setWebConfig(new WebserviceIntegrationConfig());
        this.getWebConfig().setDescription(type.name());
    }

    @Column(name="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    protected void setLabel(String value) {
        this.label = value;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="cloud_server_type")
    public CloudServerType getCloudServerType() {
        return this.cloudServerType;
    }

    protected void setCloudServerType(CloudServerType type) {
        this.cloudServerType = type;
    }

    @OneToOne(targetEntity=WebserviceIntegrationConfig.class)
    @JoinColumn(name="fk_config_integration_webservice")
    public WebserviceIntegrationConfig getWebConfig() {
        return this.webConfig.get();
    }

    public void setWebConfig(WebserviceIntegrationConfig value) {
        this.webConfig.set(value);
    }

    @Transient
    public List<CloudBackProperty> getCloudProperties() {
        return this.cloudProperties;
    }

    protected void setCloudProperties(List<CloudBackProperty> value) {
        this.cloudProperties.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.webConfig.saveChild();
        PersistenceManager.save(this);
        this.cloudProperties.saveChild();
    }

    @Override
    public void delete() {
        this.setEnabled(false);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.getLabel() == null ? "<No Label Set>" : this.getLabel();
    }

    public static CloudBackConfig getCloudBackConfig(CloudServerType type) {
        return PersistenceManager.getObject(CloudBackConfig.class, Query.select(CloudBackConfig.class).equals(CloudBackConfig.Properties.CLOUD_SERVER_TYPE, (Object)type).toString());
    }

    public String getCloudPropertyValue(String key) {
        for (CloudBackProperty property : this.cloudProperties) {
            if (!property.getKey().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    public void setCloudProperty(String key, String value) {
        CloudBackProperty prop = null;
        for (CloudBackProperty property : this.cloudProperties) {
            if (!property.getKey().equals(key)) continue;
            prop = property;
            break;
        }
        if (prop == null) {
            prop = new CloudBackProperty(this, key, value);
            this.cloudProperties.add(prop);
        } else {
            prop.setValue(value);
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Boolean> ENABLED;
        public PropertiedObject.Property<CloudServerType> CLOUD_SERVER_TYPE;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEB_CONFIG;
        public PropertiedObject.Property<CloudBackProperty> CLOUD_PROPERTIES;
    }
}

