/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.cloudback;

import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeManager;

public class NudgeBackConfiguration {
    private CloudBackConfig config;
    private CloudServerType type;
    private String errorMessage;

    public NudgeBackConfiguration(CloudBackConfig config, CloudServerType type) {
        this.config = config;
        this.type = type;
    }

    public boolean performConfiguration() {
        return this.enableNudgeConfig();
    }

    private boolean enableNudgeConfig() {
        NudgeManager nudgeManager = NudgeManager.getInstance();
        OMOutgoingServiceResponse outgoingServiceResponse = nudgeManager.linkStore(this.config.getStoreId(), !this.config.isEnabled());
        if (outgoingServiceResponse.isSuccessful()) {
            return true;
        }
        this.errorMessage = outgoingServiceResponse.getMessage();
        this.config.setEnabled(!this.config.isEnabled());
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

