/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import ordermate.database.integration.coupon.CouponIntegrationType;
import ordermate.database.integration.coupon.id.CouponIdGenerationStrategy;

@Entity
@Table(name="config_coupon")
public class CouponConfig
extends PersistentObject
implements Saveable {
    private static LocalCachedReference<CouponConfig> instance;
    public static final long DEFAULT_REMAINING = 1000000L;
    public static final Props Properties;
    private CouponIntegrationType integrationType;
    private String lastSeed;
    private CouponIdGenerationStrategy idGenStrategy;
    private long remaining;

    public static CouponConfig getInstance() {
        CouponConfig config;
        if (instance == null) {
            instance = new LocalCachedReference<CouponConfig>(new QueryReference<CouponConfig>(CouponConfig.class, Query.select(CouponConfig.class).orderBy(CouponConfig.Properties.ID)));
        }
        if ((config = instance.get()) == null) {
            config = new CouponConfig(CouponIntegrationType.Infinite);
            config.save();
            instance.collapse();
        }
        return config;
    }

    @Deprecated
    public CouponConfig() {
    }

    protected CouponConfig(CouponIntegrationType type) {
        this.integrationType = type;
        this.lastSeed = null;
        this.idGenStrategy = CouponIdGenerationStrategy.AlphaNumeric;
        this.remaining = 1000000L;
    }

    @Column(name="integration_type")
    @Enumerated(value=EnumType.STRING)
    public CouponIntegrationType getIntegrationType() {
        return this.integrationType;
    }

    @Column(name="last_seed")
    public String getLastSeed() {
        return this.lastSeed;
    }

    @Column(name="id_generation_strategy")
    @Enumerated(value=EnumType.STRING)
    public CouponIdGenerationStrategy getIdGenStrategy() {
        return this.idGenStrategy;
    }

    @Column(name="remaining")
    public long getRemaining() {
        return this.remaining;
    }

    public void setIntegrationType(CouponIntegrationType integrationType) {
        this.integrationType = integrationType;
    }

    public void setLastSeed(String lastId) {
        this.lastSeed = lastId;
    }

    public void setIdGenStrategy(CouponIdGenerationStrategy idGenStrategy) {
        this.idGenStrategy = idGenStrategy;
    }

    protected void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    static {
        Properties = new Props();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<CouponIntegrationType> INTEGRATION_TYPE;
        public PropertiedObject.Property<String> LAST_SEED;
        public PropertiedObject.Property<CouponIdGenerationStrategy> ID_GEN_STRATEGY;
        public PropertiedObject.Property<Long> REMAINING;
    }
}

