/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon;

import java.io.Serializable;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;

public class CouponTransaction
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final SalesCoupon coupon;
    private SalesCouponUsage usage;
    private String reason;
    private Status status = Status.Pending;
    private Long storeId;
    private final String uniqueId;

    public CouponTransaction(SalesCoupon yourCoupon) {
        this.coupon = yourCoupon;
        this.uniqueId = yourCoupon.getUniqueId();
    }

    public CouponTransaction(SalesCouponUsage usage) {
        this.usage = usage;
        this.coupon = usage.getCoupon();
        this.uniqueId = this.coupon.getUniqueId();
    }

    public CouponTransaction(String uniqueId) {
        this.coupon = null;
        this.uniqueId = uniqueId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getReason() {
        return this.reason;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status value, String theReason) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot set the Coupon Transaction to null!");
        }
        if (!Status.Pending.equals((Object)this.status) && !this.status.equals((Object)value)) {
            throw new IllegalStateException("Cannot reset the status of the coupon transaction, is already " + (Object)((Object)this.status));
        }
        this.status = value;
        this.reason = theReason;
    }

    public SalesCoupon getSalesCoupon() {
        return this.coupon;
    }

    public SalesCouponUsage getCouponUsage() {
        return this.usage;
    }

    public void setStoreId(Long value) {
        this.storeId = value;
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public void setCouponUsage(SalesCouponUsage newUsage) {
        if (this.usage != null && !this.usage.equals(newUsage)) {
            throw new IllegalStateException("Cannot set the usage to a different value");
        }
        this.usage = newUsage;
    }

    public boolean isSuccessful() {
        return Status.Approved.equals((Object)this.getStatus());
    }

    public static enum Status {
        Approved,
        Pending,
        Denied,
        Error;

    }
}

