/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCoupon;

public class CustomerCouponAssigner {
    private final GuiHandler handler;
    private final List<Customer> customers;
    private final CouponAdministrator admin;
    private InventoryCoupon coupon;
    private final boolean local;

    public CustomerCouponAssigner(List<Customer> yourCustomers, GuiHandler yourHandler, CouponAdministrator admin, boolean isLocal) {
        this.customers = new ArrayList<Customer>(yourCustomers);
        this.handler = yourHandler;
        this.admin = admin;
        this.local = isLocal;
    }

    public void assignCoupons() {
        List<InventoryCoupon> coupons = this.getAvailableCoupons(this.local);
        if (coupons.isEmpty()) {
            this.handler.displayOkDialog("No Coupons", "No coupons have been created yet.");
            return;
        }
        this.chooseCoupon(coupons);
        if (this.coupon == null) {
            return;
        }
        this.chooseCustomers();
        if (!this.customers.isEmpty()) {
            try {
                List<SalesCoupon> newCoupons = this.admin.generateSalesCoupons(this.coupon, this.customers);
                if (newCoupons != null) {
                    this.handler.displayOkDialog("Coupons assigned", newCoupons.size() + " coupons were assigned");
                } else {
                    this.handler.displayOkDialog("Coupons Not assigned", "The remote adminstrator could not be contacted");
                }
            }
            catch (RemoteException ex) {
                OrderMate.LOG.error("Cannot communicate with remote coupon administrator to generate coupon for customers", (Throwable)ex);
                this.handler.displayOkDialog("Coupons not assigned", "The coupons could not be created");
            }
        }
    }

    private void chooseCoupon(List<InventoryCoupon> yourCoupons) {
        if (this.coupon == null) {
            this.coupon = (InventoryCoupon)this.handler.displayChoiceDialog("Choose a coupon", "Select a coupon", yourCoupons, null);
        }
    }

    private void chooseCustomers() {
        if (this.customers == null || this.customers.isEmpty()) {
            throw new UnsupportedOperationException("Choosing Customers from the assigner is not supported by default");
        }
    }

    protected List<InventoryCoupon> getAvailableCoupons(Boolean local) {
        ObjectQuery query = Query.select(InventoryCoupon.class).greaterThan(InventoryCoupon.Properties.EXPIRES, new Date(), SQLDateType.TIMESTAMP).active(InventoryCoupon.class).equals(InventoryCoupon.Properties.LOCAL, local).equals(InventoryCoupon.Properties.PROTOTYPE, Boolean.TRUE);
        return PersistenceManager.getObjectList(InventoryCoupon.class, query.toString());
    }
}

