/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.administration;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.id.IdGenerator;
import au.com.ordermate.util.id.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.coupon.CouponConfig;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.integration.coupon.administration.CustomerCouponAllocationRule;
import ordermate.database.integration.coupon.authority.CouponAuthority;
import ordermate.database.integration.coupon.id.CouponIdGenerationStrategy;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.users.User;

public abstract class AbstractCouponAdministrator
implements CouponAdministrator {
    private final CouponAuthority authority;
    private IdGenerator generator;

    protected AbstractCouponAdministrator(CouponAuthority theAuthority) {
        this.authority = theAuthority;
    }

    protected CouponAuthority getAuthority() {
        return this.authority;
    }

    @Override
    public boolean mayBeRedeemable(CouponTransaction txn, TriggerActivationContext context) {
        Account account = context.getAccount();
        if (txn.getSalesCoupon().getInventoryCoupon().isMutEx() && account.getCouponUsages().size() > 0) {
            return false;
        }
        return txn.getSalesCoupon().getInventoryCoupon().isActive(context);
    }

    @Override
    public CouponTransaction redeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        if (!this.mayBeRedeemable(txn, context)) {
            txn.setStatus(CouponTransaction.Status.Denied, this.buildCouponConditions(txn.getSalesCoupon()));
        } else {
            try {
                this.authority.requestRedeemCoupon(txn);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot redeem coupon:", (Throwable)ex);
                txn.setStatus(CouponTransaction.Status.Error, "There was an error with redeeming the coupon.");
            }
        }
        return txn;
    }

    @Override
    public synchronized SalesCoupon generateSalesCoupon(InventoryCoupon coupon, Customer customer) {
        if (!this.canGenerateCoupon(coupon)) {
            return null;
        }
        InventoryCoupon realCoupon = this.getRealCoupon(coupon);
        CouponConfig config = CouponConfig.getInstance();
        SalesCoupon salesCoupon = this.makeCoupon(realCoupon, config, customer);
        config.save();
        return salesCoupon;
    }

    @Override
    public synchronized List<SalesCoupon> generateBulkCoupons(InventoryCoupon coupon, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot make a negative batch of coupons:" + count);
        }
        if (!this.canGenerateCoupon(coupon)) {
            return Collections.emptyList();
        }
        InventoryCoupon realCoupon = this.getRealCoupon(coupon);
        CouponConfig config = CouponConfig.getInstance();
        ArrayList<SalesCoupon> salesCoupons = new ArrayList<SalesCoupon>(count);
        for (int i = 0; i < count; ++i) {
            salesCoupons.add(this.makeCoupon(realCoupon, config, null));
        }
        config.save();
        return salesCoupons;
    }

    protected abstract boolean canGenerateCoupon(InventoryCoupon var1);

    protected InventoryCoupon getRealCoupon(InventoryCoupon coupon) {
        InventoryCoupon realCoupon = coupon;
        if (coupon.isPrototype()) {
            InventoryCoupon equivalentCoupon = PersistenceManager.getObject(InventoryCoupon.class, Query.select(InventoryCoupon.class).equals(InventoryCoupon.Properties.PROTOTYPE_COUPON, coupon).orderBy(InventoryCoupon.Properties.ID, true).limit(1).toString());
            if (equivalentCoupon == null || !equivalentCoupon.isEquivalentTo(coupon)) {
                equivalentCoupon = this.copyCoupon(coupon);
                equivalentCoupon = this.saveCoupon(equivalentCoupon);
            }
            realCoupon = equivalentCoupon;
        }
        return realCoupon;
    }

    protected InventoryCoupon copyCoupon(InventoryCoupon coupon) {
        return coupon.copy();
    }

    protected InventoryCoupon saveCoupon(InventoryCoupon coupon) {
        coupon.save();
        return coupon;
    }

    private SalesCoupon makeCoupon(InventoryCoupon coupon, CouponConfig config, Customer customer) {
        String id;
        SalesCoupon salesCoupon = null;
        String lastSeed = config.getLastSeed();
        if (this.generator == null) {
            CouponIdGenerationStrategy strategy = config.getIdGenStrategy();
            this.generator = this.createGenerator(strategy);
        }
        String seed = lastSeed;
        do {
            id = this.generator.getId(seed);
            seed = this.generator.nextSeed(seed);
            config.setLastSeed(seed);
        } while (!this.validate(id) && !seed.equals(lastSeed));
        salesCoupon = new SalesCoupon(coupon, id);
        salesCoupon.setCustomer(customer);
        this.saveSalesCoupon(salesCoupon);
        return salesCoupon;
    }

    protected void saveSalesCoupon(SalesCoupon salesCoupon) {
        salesCoupon.save();
    }

    protected boolean validate(String id) {
        return PersistenceManager.getObjectList(SalesCoupon.class, Query.select(SalesCoupon.class).equals(SalesCoupon.Properties.UNIQUE_ID, id).toString()).isEmpty();
    }

    @Override
    public synchronized List<SalesCoupon> generateSalesCoupons(InventoryCoupon coupon, List<Customer> customers) {
        ArrayList<SalesCoupon> coupons = new ArrayList<SalesCoupon>();
        InventoryCoupon realCoupon = this.getRealCoupon(coupon);
        CustomerCouponAllocationRule rule = new CustomerCouponAllocationRule();
        for (Customer customer : customers) {
            if (!rule.canAllocateToCustomer(realCoupon, customer)) continue;
            SalesCoupon salesCoupon = this.generateSalesCoupon(coupon, customer);
            coupons.add(salesCoupon);
        }
        return coupons;
    }

    @Override
    public boolean activateCoupon(SalesCoupon coupon) {
        if (coupon.getActivated() == null) {
            CouponTransaction txn = new CouponTransaction(coupon);
            try {
                this.authority.requestActivateCoupon(txn);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot activate coupon:", (Throwable)ex);
            }
            if (CouponTransaction.Status.Approved.equals((Object)txn.getStatus())) {
                OrderMate.LOG.info("Coupon activated " + coupon.getUniqueId());
                coupon.setActivated(new Date());
                this.saveSalesCoupon(coupon);
                return true;
            }
        }
        return false;
    }

    @Override
    public CouponTransaction unredeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        try {
            this.authority.requestUnredeemCoupon(txn);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot unredeem coupon:", (Throwable)ex);
        }
        return txn;
    }

    @Override
    public boolean revokeCoupon(SalesCoupon toRevoke, User user) {
        toRevoke.delete();
        StringBuilder SB = new StringBuilder("User ");
        SB.append(user.getFirstName()).append(" ").append(user.getLastName()).append(" has revoked ").append(toRevoke.getUniqueId());
        OrderMate.LOG.info(SB.toString());
        return true;
    }

    @Override
    public SalesCoupon findCoupon(String uniqueId) {
        return PersistenceManager.getObject(SalesCoupon.class, Query.select(SalesCoupon.class).equals(SalesCoupon.Properties.UNIQUE_ID, uniqueId).toString());
    }

    @Override
    public List<SalesCoupon> getValidCouponsForCustomer(Customer value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return PersistenceManager.getObjectList(SalesCoupon.class, Query.select(SalesCoupon.class).equals(SalesCoupon.Properties.CUSTOMER, value).linkUsing(SalesCoupon.Properties.INVENTORY_COUPON).equals(SalesCoupon.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).greaterThan(InventoryCoupon.Properties.EXPIRES, new Date(), SQLDateType.TIMESTAMP).lessThan(InventoryCoupon.Properties.COMMENCES, new Date(), SQLDateType.TIMESTAMP).whereFunction("sales_coupon.num_uses < inventory_coupon.max_uses").toString());
    }

    private String buildCouponConditions(SalesCoupon coupon) {
        return coupon.getInventoryCoupon().getTool().getConditionsHtml();
    }

    protected IdGenerator createGenerator(CouponIdGenerationStrategy strategy) {
        return new UUIDGenerator(12, "050");
    }
}

