/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.administration;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.integration.coupon.administration.ForeignCouponAdministrator;
import ordermate.database.integration.coupon.administration.LocalCouponAdministrator;
import ordermate.database.integration.coupon.authority.CompositeCouponAuthority;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.HOConfig;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.users.User;

public class CompositeCouponAdministrator
implements CouponAdministrator,
Serializable {
    private final long TIMEOUT = 5000L;
    public static final String RemoteName = "CouponAdminRemote";
    private static CompositeCouponAdministrator instance;

    public static CompositeCouponAdministrator getInstance() {
        return instance;
    }

    public static void init() {
        if (instance == null) {
            LocalCouponAdministrator.init(CompositeCouponAuthority.getInstance().getLocalAuthority());
            ForeignCouponAdministrator.init(CompositeCouponAuthority.getInstance().getForeignAuthority());
            instance = new CompositeCouponAdministrator();
        }
    }

    private CompositeCouponAdministrator() {
    }

    @Override
    public boolean mayBeRedeemable(CouponTransaction txn, TriggerActivationContext context) {
        try {
            return this.getAdmin(txn.getSalesCoupon()).mayBeRedeemable(txn, context);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot test for redemption", (Throwable)ex);
            return false;
        }
    }

    @Override
    public CouponTransaction redeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        try {
            return this.getAdmin(txn.getSalesCoupon()).redeemCoupon(txn, context);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot redeem coupon", (Throwable)ex);
            return txn;
        }
    }

    @Override
    public SalesCoupon generateSalesCoupon(InventoryCoupon coupon, Customer customer) {
        try {
            return this.getAdmin(coupon).generateSalesCoupon(coupon, customer);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot generate sales coupon", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<SalesCoupon> generateSalesCoupons(InventoryCoupon coupon, List<Customer> customers) {
        try {
            return this.getAdmin(coupon).generateSalesCoupons(coupon, customers);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot generate sales coupons for customers ", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<SalesCoupon> generateBulkCoupons(InventoryCoupon coupon, int count) {
        try {
            return this.getAdmin(coupon).generateBulkCoupons(coupon, count);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot bulk generate sales coupons.", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean activateCoupon(SalesCoupon coupon) {
        try {
            return this.getAdmin(coupon).activateCoupon(coupon);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot activate coupon", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean revokeCoupon(SalesCoupon toRevoke, User user) {
        try {
            return this.getAdmin(toRevoke).revokeCoupon(toRevoke, user);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot revoke coupon", (Throwable)ex);
            return false;
        }
    }

    @Override
    public SalesCoupon findCoupon(String uniqueId) {
        SalesCoupon coupon = LocalCouponAdministrator.getInstance().findCoupon(uniqueId);
        if (coupon == null) {
            coupon = ForeignCouponAdministrator.getInstance().findCoupon(uniqueId);
        }
        return coupon;
    }

    @Override
    public CouponTransaction unredeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        try {
            return this.getAdmin(txn.getSalesCoupon()).unredeemCoupon(txn, context);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot unredeem coupon", (Throwable)ex);
            return txn;
        }
    }

    private CouponAdministrator getAdmin(InventoryCoupon coupon) {
        return coupon.isLocal() ? LocalCouponAdministrator.getInstance() : ForeignCouponAdministrator.getInstance();
    }

    private CouponAdministrator getAdmin(SalesCoupon coupon) {
        return coupon.isLocal() ? LocalCouponAdministrator.getInstance() : ForeignCouponAdministrator.getInstance();
    }

    @Override
    public List<SalesCoupon> getValidCouponsForCustomer(final Customer customer) {
        if (HOConfig.getInstance().isConfigured()) {
            Thread newThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    List<SalesCoupon> foreignCoupons = ForeignCouponAdministrator.getInstance().getValidCouponsForCustomer(customer);
                }
            });
            newThread.start();
            try {
                newThread.join(5000L);
            }
            catch (InterruptedException e) {
                OrderMate.LOG.info("Interrupted while waiting for foreign coupons to be downloaded");
            }
        }
        List<SalesCoupon> coupons = LocalCouponAdministrator.getInstance().getValidCouponsForCustomer(customer);
        return coupons;
    }
}

