/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.administration;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.integration.coupon.administration.CouponDeletedRedemptionHandler;
import ordermate.database.inventory.coupon.CouponHandlerFactory;
import ordermate.database.inventory.coupon.CouponRedeemer;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.queries.inventory.coupon.InventoryCouponQueries;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class CouponAdministratorRemote
implements CouponAdministrator {
    public final Signal<Boolean, ?, ?, ?, ?> redeemDone = Signals.createSignal(Boolean.class, "success");
    private static CouponAdministratorRemote instance;
    private CouponAdministrator remoteAdmin;
    private final GuiHandler gui;
    private CouponHandlerFactory handlerFactory;

    public static CouponAdministratorRemote getInstance() {
        return instance;
    }

    public static void init(GuiHandler gui) {
        if (instance == null) {
            instance = new CouponAdministratorRemote(gui);
        }
    }

    private CouponAdministratorRemote(GuiHandler guiHandler) {
        this.gui = guiHandler;
    }

    public synchronized void setHandlerFactory(CouponHandlerFactory newFactory) {
        this.handlerFactory = newFactory;
    }

    synchronized void setRemoteAdministration(CouponAdministrator admin) {
        this.remoteAdmin = admin;
    }

    synchronized CouponAdministrator getRemoteAdministrator() {
        this.resolve();
        return this.remoteAdmin;
    }

    private synchronized boolean resolve() {
        if (this.remoteAdmin == null) {
            try {
                this.remoteAdmin = (CouponAdministrator)SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "CouponAdminRemote", 11100);
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Cannot retrieve Coupon Admin from ServerMate", (Throwable)e);
            }
            catch (NotBoundException e) {
                OrderMate.LOG.error("Cannot retrieve Coupon Admin from ServerMate, Not shared?", (Throwable)e);
            }
        }
        return this.remoteAdmin != null;
    }

    @Override
    public boolean mayBeRedeemable(CouponTransaction txn, TriggerActivationContext context) {
        if (this.resolve()) {
            try {
                return this.remoteAdmin.mayBeRedeemable(txn, context);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot test for redemption of coupon, remoteAdmin might be down", (Throwable)ex);
                this.remoteAdmin = null;
            }
        }
        return false;
    }

    @Override
    public CouponTransaction redeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        CouponTransaction theTxn = txn;
        if (this.resolve()) {
            try {
                theTxn = this.remoteAdmin.redeemCoupon(txn, context);
                if (theTxn.isSuccessful()) {
                    if (this.handleRedemption(txn, context)) {
                        TerminalEventLog.logCouponUsage(txn.getSalesCoupon(), true, context);
                        return theTxn;
                    }
                    OrderMate.LOG.warn("Cannot redeem coupon");
                    this.handleCannotRedeem(theTxn, "Coupon redemption failed. Please see logs");
                    CouponTransaction unTxn = new CouponTransaction(theTxn.getSalesCoupon());
                    this.remoteAdmin.unredeemCoupon(unTxn, context);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot Redeem coupon, remoteAdmin might be down", (Throwable)ex);
                theTxn.setStatus(CouponTransaction.Status.Error, "Cannot redeem coupon. Remote Coupon Administration might be down");
                this.remoteAdmin = null;
            }
        } else {
            theTxn.setStatus(CouponTransaction.Status.Error, "The remote coupon administration cannot be reached.");
        }
        this.handleCannotRedeem(theTxn, null);
        return theTxn;
    }

    @Override
    public SalesCoupon generateSalesCoupon(InventoryCoupon coupon, Customer customer) {
        if (this.resolve()) {
            try {
                return this.remoteAdmin.generateSalesCoupon(coupon, customer);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot create a new SalesCoupon, remoteAdmin might be down", (Throwable)ex);
                this.remoteAdmin = null;
            }
        }
        return null;
    }

    @Override
    public List<SalesCoupon> generateBulkCoupons(InventoryCoupon coupon, int count) {
        if (this.resolve()) {
            try {
                return this.remoteAdmin.generateBulkCoupons(coupon, count);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot batch create sales coupons, remoteAdmin might be down", (Throwable)ex);
                this.remoteAdmin = null;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<SalesCoupon> generateSalesCoupons(InventoryCoupon coupon, List<Customer> customers) {
        if (this.resolve()) {
            try {
                return this.remoteAdmin.generateSalesCoupons(coupon, customers);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot batch create sales coupons, remoteAdmin might be down", (Throwable)ex);
                this.remoteAdmin = null;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean activateCoupon(SalesCoupon coupon) {
        if (this.resolve()) {
            try {
                return this.remoteAdmin.activateCoupon(coupon);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot activate coupon, remoteAdmin might be down", (Throwable)ex);
                this.remoteAdmin = null;
            }
        }
        return false;
    }

    @Override
    public boolean revokeCoupon(SalesCoupon toRevoke, User user) {
        try {
            return this.remoteAdmin.revokeCoupon(toRevoke, user);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot revoke coupon, remoteAdmin might be down", (Throwable)ex);
            this.remoteAdmin = null;
            return false;
        }
    }

    @Override
    public CouponTransaction unredeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        CouponTransaction theTxn = txn;
        try {
            theTxn = this.remoteAdmin.unredeemCoupon(theTxn, context);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot Unredeem coupon, remoteAdmin might be down", (Throwable)ex);
            theTxn.setStatus(CouponTransaction.Status.Error, "Remote Coupon Administration cannot be contacted.");
            this.remoteAdmin = null;
        }
        if (theTxn.isSuccessful()) {
            TerminalEventLog.logCouponUsage(txn.getSalesCoupon(), false, context);
            if (theTxn.getCouponUsage() != null && theTxn.getCouponUsage().isPersistent()) {
                theTxn.getCouponUsage().deleteChild();
            }
        }
        return theTxn;
    }

    @Override
    public SalesCoupon findCoupon(String uniqueId) {
        try {
            if (this.resolve()) {
                return this.remoteAdmin.findCoupon(uniqueId);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot find coupon of id :" + uniqueId + ", remoteAdmin might be down", (Throwable)ex);
            this.remoteAdmin = null;
        }
        return null;
    }

    @Override
    public List<SalesCoupon> getValidCouponsForCustomer(Customer customer) {
        try {
            if (this.resolve()) {
                return this.remoteAdmin.getValidCouponsForCustomer(customer);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot find coupons for customer " + customer + ", remoteAdmin might be down", (Throwable)ex);
            this.remoteAdmin = null;
        }
        return Collections.emptyList();
    }

    private boolean handleRedemption(CouponTransaction txn, TriggerActivationContext context) {
        if (context.getAccount() == null) {
            OrderMate.LOG.error("No account was associated with the coupon");
            return false;
        }
        if (this.handlerFactory == null) {
            OrderMate.LOG.error("No coupon handler factory has been set.");
            return false;
        }
        CouponRedeemer handler = this.handlerFactory.getCouponRedeemer(txn.getSalesCoupon(), context);
        handler.getRedeemDoneSignal().connect(this, "gotRedeemDone");
        return handler.handleCouponRedemption(context);
    }

    private void handleCannotRedeem(CouponTransaction txn, String alternateReason) {
        this.gui.displayOkDialog("Cannot Redeem Coupon", "<html>" + (alternateReason == null ? txn.getReason() : alternateReason) + "</html>");
    }

    public void gotRedeemDone(CouponRedeemer handler, Boolean complete) {
        handler.getRedeemDoneSignal().disconnect(this);
        if (!Boolean.TRUE.equals(complete)) {
            this.unredeemCoupon(new CouponTransaction(handler.getHandledCoupon()), handler.getContext());
        }
        this.redeemDone.emit(complete);
    }

    public void accountSaved(TriggerActivationContext context) {
        List<SalesCouponUsage> usages = context.getAccount().getCouponUsages();
        if (!usages.isEmpty()) {
            final CouponDeletedRedemptionHandler unredeemer = new CouponDeletedRedemptionHandler(context.getAccount(), new ArrayList<SalesCouponUsage>(usages), this.handlerFactory, context);
            Thread runner = new Thread(new Runnable(){

                @Override
                public void run() {
                    unredeemer.examineAccount();
                }
            });
            runner.start();
        }
    }

    public List<SalesCoupon> accountClosed(TriggerActivationContext context) {
        ObjectQuery query = InventoryCouponQueries.getAutoGenCoupons();
        List<InventoryCoupon> coupons = PersistenceManager.getObjectList(InventoryCoupon.class, query.toString());
        ArrayList<SalesCoupon> generated = new ArrayList<SalesCoupon>();
        for (InventoryCoupon coupon : coupons) {
            SalesCoupon salesCoupon;
            if (!coupon.isAutoGenActive(context) || (salesCoupon = this.generateSalesCoupon(coupon, context.getCustomer() == null ? context.getAccount().getCustomer() : context.getCustomer())) == null) continue;
            generated.add(salesCoupon);
            this.printCoupon(context, salesCoupon);
            return generated;
        }
        return null;
    }

    private void printCoupon(TriggerActivationContext context, SalesCoupon salesCoupon) {
        try {
            DocketProcessor.printCouponDocket(salesCoupon, context);
            this.showCouponPrintSuccessDialog(salesCoupon);
        }
        catch (IOException e) {
            OrderMate.LOG.error("Couldn't print coupon " + salesCoupon.getLabel() + " reason " + e.getMessage());
        }
    }

    private void showCouponPrintSuccessDialog(SalesCoupon salesCoupon) {
        if (this.gui != null) {
            this.gui.displayOkDialog(salesCoupon.getLabel() + " coupon has been generated for this order. Retrieve the coupon from docket printer.", "New Coupon Generated!");
        }
    }
}

