/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.administration;

import java.util.List;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.inventory.coupon.CouponHandlerFactory;
import ordermate.database.inventory.coupon.CouponUnredeemer;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.coupon.SalesCouponUsage;

class CouponDeletedRedemptionHandler {
    private final Account account;
    private final CouponHandlerFactory factory;
    private final List<SalesCouponUsage> usages;
    private final TriggerActivationContext context;

    CouponDeletedRedemptionHandler(Account yourAccount, List<SalesCouponUsage> yourUsages, CouponHandlerFactory yourFactory, TriggerActivationContext context) {
        this.account = yourAccount;
        this.factory = yourFactory;
        this.usages = yourUsages;
        this.context = context;
    }

    void examineAccount() {
        for (SalesCouponUsage usage : this.usages) {
            CouponUnredeemer unredeemer;
            if (!SystemState.ACTIVE_STATE.equals(usage.getSystemState()) || !(unredeemer = this.factory.getCouponUnredeemer(usage, this.context)).hasBeenDeleted()) continue;
            CouponTransaction txn = CouponAdministratorRemote.getInstance().unredeemCoupon(new CouponTransaction(usage), this.context);
            if (txn.isSuccessful()) {
                OrderMate.LOG.info("Unredeemed coupon usage for SalesCoupon " + usage.getCoupon().getUniqueId());
                continue;
            }
            OrderMate.LOG.warn("Couldn't unredeem usage for SalesCoupon " + usage.getCoupon().getUniqueId() + " reason " + txn.getReason());
        }
    }
}

