/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.administration;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.SyncPersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncReceiver;
import au.com.ordermate.persistence.synchronisation.PosPersistentObjectCreator;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.administration.CouponAdministrator;
import ordermate.database.integration.coupon.authority.ForeignCouponAuthority;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.HOTriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.users.User;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.integration.webservice.RestHelper;

public class ForeignCouponAdministrator
implements CouponAdministrator {
    private static ForeignCouponAdministrator instance;
    private final Integer TIMEOUT = 5000;
    private final String PATH = "synchronize/coupons/";
    private final String COUPON = "synchronize/coupons/inventoryCoupon";
    private final String SALES_COUPON = "synchronize/coupons/salesCoupon";
    private final String COUPONS_FOR_CUSTOMER = "synchronize/coupons/couponsForCustomer";
    private final String MAY_REDEEM = "synchronize/coupons/redeemAvailable";
    private final String REVOKE = "synchronize/coupons/revoke";
    private final String CONTEXT = "context";
    private ForeignCouponAuthority authority;
    private PosPersistentObjectCreator creator;

    public static ForeignCouponAdministrator getInstance() {
        return instance;
    }

    public static synchronized void init(ForeignCouponAuthority theAuthority) {
        if (instance == null) {
            instance = new ForeignCouponAdministrator(theAuthority);
        }
    }

    private ForeignCouponAdministrator(ForeignCouponAuthority auth) {
        this.authority = auth;
    }

    @Override
    public boolean mayBeRedeemable(CouponTransaction txn, TriggerActivationContext context) {
        Account account = context.getAccount();
        if (txn.getSalesCoupon().getInventoryCoupon().isMutEx() && account.getCouponUsages().size() > 0) {
            for (SalesCouponUsage usage : account.getCouponUsages()) {
                if (!SystemState.ACTIVE_STATE.equals(usage.getSystemState())) continue;
                return false;
            }
        }
        return this.isCouponActiveForeign(txn, context);
    }

    @Override
    public SalesCoupon findCoupon(String uniqueId) {
        SalesCoupon coupon = PersistenceManager.getObject(SalesCoupon.class, Query.select(SalesCoupon.class).equals(SalesCoupon.Properties.UNIQUE_ID, uniqueId).toString());
        if (coupon == null) {
            RestHelper rest = new RestHelper();
            WebResource resource = this.buildService("synchronize/coupons/salesCoupon", uniqueId, rest);
            try {
                SynchronisationSnapshot couponSnappy = (SynchronisationSnapshot)resource.get(SynchronisationSnapshot.class);
                this.initCreator();
                Long invCouponId = (Long)couponSnappy.get(SalesCoupon.Properties.INVENTORY_COUPON.getName());
                if (invCouponId != null && this.resolveInventoryCoupon(invCouponId) != null) {
                    coupon = (SalesCoupon)this.creator.createFromSnapShotContent(couponSnappy);
                    if (coupon != null) {
                        this.saveForeignObject(coupon);
                        OrderMate.LOG.info("Saving SalesCoupon " + uniqueId);
                    }
                } else {
                    OrderMate.LOG.warn("Sales Coupon " + uniqueId + " cannot be saved, since inventoryCoupon doesn't exist " + invCouponId);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot contact webservice to get coupon " + uniqueId, (Throwable)ex);
            }
        }
        return coupon;
    }

    @Override
    public CouponTransaction redeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        if (this.mayBeRedeemable(txn, context)) {
            try {
                this.authority.requestRedeemCoupon(txn);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot redeem coupon:", (Throwable)ex);
                txn.setStatus(CouponTransaction.Status.Error, "There was an error with redeeming the coupon.");
            }
        }
        return txn;
    }

    @Override
    public CouponTransaction unredeemCoupon(CouponTransaction txn, TriggerActivationContext context) {
        try {
            this.authority.requestUnredeemCoupon(txn);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot redeem coupon:", (Throwable)ex);
            txn.setStatus(CouponTransaction.Status.Error, "There was an error with redeeming the coupon.");
        }
        return txn;
    }

    @Override
    public SalesCoupon generateSalesCoupon(InventoryCoupon coupon, Customer customer) {
        return null;
    }

    @Override
    public List<SalesCoupon> generateBulkCoupons(InventoryCoupon coupon, int count) {
        return Collections.emptyList();
    }

    @Override
    public List<SalesCoupon> generateSalesCoupons(InventoryCoupon coupon, List<Customer> customers) {
        return new ArrayList<SalesCoupon>();
    }

    @Override
    public List<SalesCoupon> getValidCouponsForCustomer(Customer customer) {
        RestHelper rest = new RestHelper();
        WebResource resource = this.buildEndPoint("synchronize/coupons/couponsForCustomer", rest);
        resource = rest.addParameter(resource, "customerId", new LocalIdTranslator().convertToHOId(customer.getID()).toString());
        resource = rest.addParameter(resource, "storeId", StoreGroup.getInstance().getStoreId().toString());
        ArrayList<SalesCoupon> result = null;
        try {
            String csv = (String)resource.accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).get(String.class);
            List<String> uniqueIds = StringUtils.splitToList(csv, ",");
            result = new ArrayList(uniqueIds.size());
            for (String nextId : uniqueIds) {
                result.add(this.findCoupon(nextId));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot contact webservice to get foreign coupons for this customer:", (Throwable)ex);
        }
        return result == null ? new ArrayList<SalesCoupon>() : result;
    }

    @Override
    public boolean activateCoupon(SalesCoupon coupon) {
        CouponTransaction txn = new CouponTransaction(coupon);
        try {
            this.authority.requestActivateCoupon(txn);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot redeem coupon:", (Throwable)ex);
            txn.setStatus(CouponTransaction.Status.Error, "There was an error with redeeming the coupon.");
        }
        return txn.isSuccessful();
    }

    @Override
    public boolean revokeCoupon(SalesCoupon toRevoke, User user) {
        boolean success = false;
        RestHelper rest = new RestHelper();
        WebResource resource = this.buildService("synchronize/coupons/revoke", toRevoke.getUniqueId(), rest);
        resource = rest.addParameter(resource, "userId", user.getID().toString());
        try {
            Boolean result = (Boolean)resource.accept(new String[]{"application/octet-stream"}).get(Boolean.class);
            if (result != null && result.booleanValue()) {
                success = true;
                toRevoke.delete();
                OrderMate.LOG.info("Sales coupon has been revoked at the foreign admin");
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot contact webservice to get foreign coupons for this customer:", (Throwable)ex);
        }
        return success;
    }

    public InventoryCoupon resolveInventoryCoupon(long invCouponId) {
        InventoryCoupon coupon = PersistenceManager.getByID(invCouponId, InventoryCoupon.class);
        if (coupon == null) {
            RestHelper rest = new RestHelper();
            WebResource resource = this.buildEndPoint("synchronize/coupons/inventoryCoupon", rest);
            resource = rest.addParameter(resource, "couponId", Long.toString(invCouponId));
            try {
                SynchronisationSnapshot couponSnap = (SynchronisationSnapshot)resource.accept(new String[]{"application/octet-stream"}).get(SynchronisationSnapshot.class);
                if (couponSnap != null) {
                    this.initCreator();
                    this.saveForeignObject(this.creator.createFromSnapShotContent(couponSnap));
                    OrderMate.LOG.info("Coupon has been downloaded " + invCouponId);
                    coupon = PersistenceManager.getByID(invCouponId, InventoryCoupon.class);
                    if (coupon != null && coupon.getTriggers().isEmpty()) {
                        coupon.addTrigger(AbstractTrigger.getDefaultTriggerIfExists());
                        coupon.save();
                    }
                } else {
                    OrderMate.LOG.info("Could not find inventoryCoupon of ID " + invCouponId + " from foreign host");
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot interrogate foreign service for InventoryCoupon " + invCouponId, (Throwable)ex);
            }
        }
        return coupon;
    }

    private WebResource buildService(String endPoint, String couponId, RestHelper rest) {
        return this.addBasicParams(rest, couponId, this.buildEndPoint(endPoint, rest));
    }

    private WebResource buildEndPoint(String endPoint, RestHelper rest) {
        StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation());
        SB.append(endPoint);
        WebResource resource = rest.getResource(SB.toString(), this.TIMEOUT, this.TIMEOUT);
        resource = rest.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), StoreGroup.getInstance().getStoreId().toString());
        return resource;
    }

    private WebResource addBasicParams(RestHelper rest, String couponId, WebResource resource) {
        WebResource newResource = resource;
        newResource = rest.addParameter(resource, "uniqueId", couponId);
        newResource = rest.addParameter(newResource, "storeId", StoreGroup.getInstance().getStoreId().toString());
        return newResource;
    }

    private boolean isCouponActiveForeign(CouponTransaction txn, TriggerActivationContext posContext) {
        RestHelper rest = new RestHelper();
        WebResource resource = this.buildService("synchronize/coupons/redeemAvailable", txn.getSalesCoupon().getUniqueId(), rest);
        HOTriggerActivationContext context = new HOTriggerActivationContext(posContext);
        resource = rest.addParameter(resource, "userId", Long.toString(context.getUserId()));
        resource = rest.addParameter(resource, "accountId", Long.toString(context.getAccountId()));
        resource = rest.addParameter(resource, "terminalId", Long.toString(context.getTerminalId()));
        resource = rest.addParameter(resource, "tradingDayId", Long.toString(context.getTradingDayId()));
        resource = rest.addParameter(resource, "shiftId", Long.toString(context.getShiftId()));
        resource = rest.addParameter(resource, "customerId", Long.toString(context.getCustomerId()));
        resource = rest.addParameter(resource, "dateInMillis", Long.toString(context.getDateInMillis()));
        resource = rest.addParameter(resource, "accountType", context.getAccountType());
        resource = rest.addParameter(resource, "accountSavedTotal", Double.toString(context.getAccountSavedTotal()));
        try {
            CouponTransaction returnedTxn = (CouponTransaction)resource.accept(new String[]{"application/octet-stream"}).get(CouponTransaction.class);
            if (returnedTxn != null) {
                if (returnedTxn.isSuccessful()) {
                    return true;
                }
                txn.setStatus(CouponTransaction.Status.Denied, returnedTxn.getReason());
            } else {
                txn.setStatus(CouponTransaction.Status.Error, "Cannot communicate with Remote Coupon Administrator");
            }
            return false;
        }
        catch (Exception ex) {
            txn.setStatus(CouponTransaction.Status.Error, "Error communicationg with Remote Coupon Administrator");
            OrderMate.LOG.error("Cannot contact webservice to check if is a coupon is trigger active.", (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCreator() {
        if (this.creator == null) {
            ForeignCouponAdministrator foreignCouponAdministrator = this;
            synchronized (foreignCouponAdministrator) {
                if (this.creator == null) {
                    this.creator = new PosPersistentObjectCreator(new LocalIdTranslator());
                }
            }
        }
    }

    private void saveForeignObject(PersistentObject obj) throws Exception {
        SyncPersistentObjectSnapshot snappy = obj.getSnapshot();
        if (obj.getID() != null && PersistenceManager.getByID(obj.getID(), obj.getObjectType()) == null) {
            snappy = new SyncPersistentObjectSnapshot(snappy);
        }
        PersistenceSyncReceiver.getInstance().saveOrUpdate(snappy);
    }
}

