/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.authority;

import java.io.Serializable;
import java.rmi.RemoteException;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.authority.CouponAuthority;
import ordermate.database.integration.coupon.authority.ForeignCouponAuthority;
import ordermate.database.integration.coupon.authority.LocalCouponAuthority;

public class CompositeCouponAuthority
implements CouponAuthority,
Serializable {
    public static final String RemoteName = "CouponAuthRemote";
    private static CompositeCouponAuthority instance;

    public static CompositeCouponAuthority getInstance() {
        return instance;
    }

    public static void init() {
        if (instance == null) {
            instance = new CompositeCouponAuthority();
        }
    }

    @Override
    public CouponTransaction requestRedeemCoupon(CouponTransaction txn) throws RemoteException {
        return this.getAuthority(txn).requestRedeemCoupon(txn);
    }

    @Override
    public CouponTransaction requestUnredeemCoupon(CouponTransaction txn) throws RemoteException {
        return this.getAuthority(txn).requestUnredeemCoupon(txn);
    }

    @Override
    public CouponTransaction requestActivateCoupon(CouponTransaction txn) throws RemoteException {
        return this.getAuthority(txn).requestActivateCoupon(txn);
    }

    @Override
    public CouponTransaction revalidateCoupon(CouponTransaction toRevalidate) throws RemoteException {
        return this.getAuthority(toRevalidate).revalidateCoupon(toRevalidate);
    }

    private CouponAuthority getAuthority(CouponTransaction txn) {
        return txn.getSalesCoupon().isLocal() ? this.getLocalAuthority() : this.getForeignAuthority();
    }

    public LocalCouponAuthority getLocalAuthority() {
        return LocalCouponAuthority.getInstance();
    }

    public ForeignCouponAuthority getForeignAuthority() {
        return ForeignCouponAuthority.getInstance();
    }
}

