/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.authority;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.coupon.PeriodUnit;
import ordermate.database.reports.general.DateReport;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;

public class CouponAuthorityStick {
    public boolean checkValid(CouponTransaction txn) {
        if (!CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
            return false;
        }
        String error = null;
        if (txn.getSalesCoupon() == null) {
            error = "No coupon has been attached";
        } else if (txn.getSalesCoupon().getInventoryCoupon() == null) {
            error = "No backing InventoryCoupon can be found for this coupon: " + txn.getSalesCoupon().getUniqueId();
        } else if (txn.getSalesCoupon().getInventoryCoupon().getExpires() == null) {
            error = "No expiry has been set for the coupon " + txn.getSalesCoupon().getUniqueId();
        } else if (!SystemState.ACTIVE_STATE.equals(txn.getSalesCoupon().getSystemState())) {
            error = "This coupon has been revoked and cannot be redeemed: " + txn.getSalesCoupon().getUniqueId();
        }
        if (error != null) {
            OrderMate.LOG.warn("Cannot authorise coupon transaction: " + error);
            txn.setStatus(CouponTransaction.Status.Error, error);
        }
        return CouponTransaction.Status.Pending.equals((Object)txn.getStatus());
    }

    public boolean checkValidUnredeem(CouponTransaction txn) {
        if (!this.checkValid(txn)) {
            return false;
        }
        String error = null;
        if (txn.getCouponUsage() != null && !txn.getSalesCoupon().equals(txn.getCouponUsage().getCoupon())) {
            error = "Incorrect usage supplied. Does not match coupon! " + txn.getSalesCoupon().getUniqueId() + " usage " + txn.getCouponUsage().getID();
        }
        if (error != null) {
            txn.setStatus(CouponTransaction.Status.Error, error);
        }
        return error != null;
    }

    public void checkMaxUses(CouponTransaction txn) {
        if (!CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
            return;
        }
        SalesCoupon coupon = txn.getSalesCoupon();
        InventoryCoupon invCoupon = coupon.getInventoryCoupon();
        if (invCoupon.getMaxUses() > 0 && (coupon = (SalesCoupon)PersistenceManager.reacquire(coupon)).getNumUses() >= invCoupon.getMaxUses()) {
            StringBuilder SB = new StringBuilder("The coupon ");
            SB.append(coupon.getInventoryCoupon().getLabel()).append(" can only be used ");
            if (coupon.getInventoryCoupon().getMaxUses() == 1) {
                SB.append("once.");
            } else {
                SB.append("a maximum of ").append(invCoupon.getMaxUses()).append(" times.");
            }
            txn.setStatus(CouponTransaction.Status.Denied, SB.toString());
        }
    }

    public void checkMaxUsesPerPeriod(CouponTransaction txn) {
        if (!CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
            return;
        }
        SalesCoupon coupon = txn.getSalesCoupon();
        InventoryCoupon invCoupon = coupon.getInventoryCoupon();
        if (invCoupon.getMaxUsesPerPeriod() > 0) {
            DateReport lastUse = PersistenceManager.getObject(DateReport.class, Query.select(SalesCouponUsage.Properties.ID).select(SalesCouponUsage.Properties.DATE_USED, "value").select("1", "mod_count").select("0", "store_id").equals(SalesCouponUsage.Properties.COUPON, coupon).equals(SalesCouponUsage.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).orderBy(SalesCouponUsage.Properties.DATE_USED, true).toString());
            if (lastUse == null) {
                return;
            }
            Date lowerDate = this.getLowerDateFor(invCoupon.getPeriodUnit());
            NumberReport report = PersistenceManager.getObject(NumberReport.class, Query.count(SalesCouponUsage.class, "value").select("1", "mod_count").select("0", "store_id").equals(SalesCouponUsage.Properties.COUPON, coupon).equals(SalesCouponUsage.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).greaterThan(SalesCouponUsage.Properties.DATE_USED, lowerDate, SQLDateType.TIMESTAMP).toString());
            if (report.getValue() >= (long)invCoupon.getMaxUses()) {
                StringBuilder SB = new StringBuilder("The coupon ");
                SB.append(coupon.getInventoryCoupon().getLabel()).append(" can only be used");
                if (invCoupon.getMaxUsesPerPeriod() == 1) {
                    SB.append(" once");
                } else {
                    SB.append(" a maximum of ").append(invCoupon.getMaxUsesPerPeriod()).append(" times");
                }
                SB.append(" per ").append(invCoupon.getPeriodUnit().name());
                txn.setStatus(CouponTransaction.Status.Denied, SB.toString());
            }
        }
    }

    private Date getLowerDateFor(PeriodUnit unit) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(unit.getCalendarField(), -unit.getRollValue());
        return cal.getTime();
    }

    public void checkExpiry(CouponTransaction txn) {
        if (!CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
            return;
        }
        Date now = new Date();
        if (now.after(txn.getSalesCoupon().getInventoryCoupon().getExpires())) {
            StringBuilder SB = new StringBuilder("The coupon ");
            SB.append(txn.getSalesCoupon().getInventoryCoupon().getLabel()).append(" expires on ").append(DateFormat.getDateInstance().format(txn.getSalesCoupon().getInventoryCoupon().getExpires()));
            txn.setStatus(CouponTransaction.Status.Denied, SB.toString());
        } else if (now.before(txn.getSalesCoupon().getInventoryCoupon().getCommences())) {
            StringBuilder SB = new StringBuilder("The coupon ");
            SB.append(txn.getSalesCoupon().getInventoryCoupon().getLabel()).append(" commences on ").append(DateFormat.getDateInstance().format(txn.getSalesCoupon().getInventoryCoupon().getExpires()));
            txn.setStatus(CouponTransaction.Status.Denied, SB.toString());
        }
    }
}

