/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.authority;

import com.sun.jersey.api.client.WebResource;
import java.rmi.Remote;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.authority.CouponAuthority;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.integration.webservice.RestHelper;

public class ForeignCouponAuthority
implements CouponAuthority,
Remote {
    private final Integer TIMEOUT = 5000;
    private final String PATH = "synchronize/coupons/";
    private final String REDEEM = "synchronize/coupons/redeem";
    private final String UNREDEEM = "synchronize/coupons/unredeem";
    private final String REVALIDATE = "synchronize/coupons/revalidate";
    private final String ACTIVATE = "synchronize/coupons/activate";
    private static ForeignCouponAuthority instance;
    private RestHelper rest = new RestHelper();
    private LocalIdTranslator translator = new LocalIdTranslator();

    public static ForeignCouponAuthority getInstance() {
        if (instance == null) {
            instance = new ForeignCouponAuthority();
        }
        return instance;
    }

    private ForeignCouponAuthority() {
    }

    @Override
    public CouponTransaction requestRedeemCoupon(CouponTransaction txn) {
        this.performService("synchronize/coupons/redeem", txn);
        return txn;
    }

    @Override
    public CouponTransaction requestUnredeemCoupon(CouponTransaction txn) {
        this.performService("synchronize/coupons/unredeem", txn);
        return txn;
    }

    @Override
    public CouponTransaction requestActivateCoupon(CouponTransaction txn) {
        this.performService("synchronize/coupons/activate", txn);
        return txn;
    }

    @Override
    public CouponTransaction revalidateCoupon(CouponTransaction txn) {
        this.performService("synchronize/coupons/revalidate", txn);
        return txn;
    }

    private CouponTransaction performService(String service, CouponTransaction txn) {
        WebResource resource = this.buildService(service, txn);
        CouponTransaction remoteTxn = (CouponTransaction)resource.accept(new String[]{"application/octet-stream"}).put(CouponTransaction.class);
        this.applyRemoteTxn(remoteTxn, txn);
        return txn;
    }

    private WebResource buildService(String endPoint, CouponTransaction txn) {
        StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation());
        SB.append(endPoint);
        WebResource resource = this.rest.getResource(SB.toString(), this.TIMEOUT, this.TIMEOUT);
        resource = this.rest.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), StoreGroup.getInstance().getStoreId().toString());
        resource = this.rest.addParameter(resource, "uniqueId", txn.getSalesCoupon().getUniqueId());
        resource = this.rest.addParameter(resource, "storeId", StoreGroup.getInstance().getStoreId().toString());
        return resource;
    }

    private void applyRemoteTxn(CouponTransaction returnedTxn, CouponTransaction initialTxn) {
        if (returnedTxn != null) {
            initialTxn.setStatus(returnedTxn.getStatus(), returnedTxn.getReason());
        } else {
            initialTxn.setStatus(CouponTransaction.Status.Error, "Foriegn Coupon service could not be contacted.");
        }
    }
}

