/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.integration.coupon.authority;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.coupon.CouponTransaction;
import ordermate.database.integration.coupon.authority.CouponAuthority;
import ordermate.database.integration.coupon.authority.CouponAuthorityStick;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;

public class LocalCouponAuthority
implements CouponAuthority,
Remote {
    protected static volatile LocalCouponAuthority instance;
    private Map<SalesCoupon, Semaphore> lockingMap = new ConcurrentHashMap<SalesCoupon, Semaphore>();
    private CouponAuthorityStick stick;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalCouponAuthority getInstance() {
        if (instance != null) return instance;
        Class<LocalCouponAuthority> clazz = LocalCouponAuthority.class;
        synchronized (LocalCouponAuthority.class) {
            if (instance != null) return instance;
            instance = new LocalCouponAuthority();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected LocalCouponAuthority() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean obtainLock(SalesCoupon coupon) {
        Semaphore lock = null;
        Map<SalesCoupon, Semaphore> map = this.lockingMap;
        synchronized (map) {
            if (!this.lockingMap.containsKey(coupon)) {
                this.lockingMap.put(coupon, new Semaphore(1, true));
            }
            lock = this.lockingMap.get(coupon);
        }
        try {
            return lock.tryAcquire(this.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.error("Interrupted while attempting to get talking stick for coupon.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(SalesCoupon coupon) {
        Map<SalesCoupon, Semaphore> map = this.lockingMap;
        synchronized (map) {
            Semaphore lock = this.lockingMap.get(coupon);
            if (lock != null) {
                if (!lock.hasQueuedThreads()) {
                    this.lockingMap.remove(coupon);
                }
                lock.release();
            } else {
                OrderMate.LOG.warn("Strange situation: I should have a semaphore to release for my coupon, but it has already been removed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CouponTransaction requestRedeemCoupon(CouponTransaction txn) {
        if (!this.getAuthorityStick().checkValid(txn)) {
            return txn;
        }
        SalesCoupon coupon = txn.getSalesCoupon();
        if (!this.obtainLock(coupon)) {
            txn.setStatus(CouponTransaction.Status.Error, "A timeout occurred while waiting to access the coupon.");
        } else {
            try {
                coupon = (SalesCoupon)PersistenceManager.reacquire(coupon);
                CouponAuthorityStick stick = this.getAuthorityStick();
                stick.checkExpiry(txn);
                stick.checkMaxUses(txn);
                stick.checkMaxUsesPerPeriod(txn);
                if (CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
                    if (coupon.getActivated() == null) {
                        coupon.setActivated(new Date());
                    }
                    coupon.setNumUses(coupon.getNumUses() + 1);
                    this.saveCoupon(coupon);
                    txn.setStatus(CouponTransaction.Status.Approved, "Coupon usage has been approved");
                    OrderMate.LOG.info("Approved use of coupon:" + txn.getUniqueId());
                }
            }
            finally {
                this.releaseLock(coupon);
            }
        }
        return txn;
    }

    @Override
    public CouponTransaction requestUnredeemCoupon(CouponTransaction txn) {
        if (this.getAuthorityStick().checkValidUnredeem(txn)) {
            return txn;
        }
        SalesCoupon coupon = txn.getSalesCoupon();
        if (!this.obtainLock(coupon = (SalesCoupon)PersistenceManager.reacquire(coupon))) {
            txn.setStatus(CouponTransaction.Status.Error, "A timeout occurred while waiting to access the coupon.");
        } else {
            try {
                if (CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
                    coupon.setNumUses(coupon.getNumUses() - 1);
                    this.saveCoupon(coupon);
                    txn.setStatus(CouponTransaction.Status.Approved, "Coupon unredemption has been approved");
                }
            }
            finally {
                this.releaseLock(coupon);
            }
        }
        return txn;
    }

    @Override
    public CouponTransaction requestActivateCoupon(CouponTransaction txn) {
        if (!this.getAuthorityStick().checkValid(txn)) {
            OrderMate.LOG.info("Invalid transaction, cannot active coupon");
            return txn;
        }
        SalesCoupon coupon = txn.getSalesCoupon();
        if (!this.obtainLock(coupon)) {
            txn.setStatus(CouponTransaction.Status.Error, "A timeout occurred while waiting to access the coupon.");
        } else {
            try {
                if (CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
                    txn.setStatus(CouponTransaction.Status.Approved, "Coupon may be activated");
                }
            }
            finally {
                this.releaseLock(coupon);
            }
        }
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CouponTransaction revalidateCoupon(CouponTransaction txn) throws RemoteException {
        if (!this.getAuthorityStick().checkValid(txn)) {
            OrderMate.LOG.info("Invalid transaction, cannot active coupon");
            return txn;
        }
        SalesCoupon coupon = txn.getSalesCoupon();
        if (!this.obtainLock(coupon)) {
            txn.setStatus(CouponTransaction.Status.Error, "A timeout occurred while waiting to access the coupon.");
        } else {
            try {
                if (CouponTransaction.Status.Pending.equals((Object)txn.getStatus())) {
                    try {
                        ObjectQuery query = Query.count(SalesCouponUsage.class, "value").equals(SalesCouponUsage.Properties.COUPON, coupon.getID()).equals(SalesCouponUsage.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE);
                        NumberReport report = PersistenceManager.getObject(NumberReport.class, query.toString());
                        coupon.setNumUses(report.getValue().intValue());
                        this.saveCoupon(coupon);
                        txn.setStatus(CouponTransaction.Status.Approved, "Coupon may be activated");
                    }
                    catch (Exception ex) {
                        txn.setStatus(CouponTransaction.Status.Error, "A problem occured while counting the usages.");
                    }
                }
            }
            finally {
                this.releaseLock(coupon);
            }
        }
        return txn;
    }

    protected void saveCoupon(SalesCoupon coupon) {
        coupon.save();
    }

    protected CouponAuthorityStick getAuthorityStick() {
        if (this.stick == null) {
            this.stick = this.createAuthorityStick();
        }
        return this.stick;
    }

    protected CouponAuthorityStick createAuthorityStick() {
        return new CouponAuthorityStick();
    }

    protected long getTimeout() {
        return 5000L;
    }
}

